import { FilterExpressions, FilterOperations } from './filters';
import { Pagination } from './pagination';
/**
 * TableConfigs
 */
export declare class TableConfigs {
    /**
     * defines the type of pagination we want and all the pagination settings
     */
    pagination: Pagination;
    /**
     * default columns to show
     */
    defaultColumns: string[];
    /**
     * columns in which the global filter is searched
     */
    globalFilterFields: string[];
    /**
     * global filter oprarion out value
     */
    globalFilterOperation: FilterOperations;
    /**
     * global filter expression
     */
    globalFilterExpression: FilterExpressions;
    /**
     * filter delay
     */
    filterDelay: number;
    /**
     * multi sorte meta
     */
    multiSortMeta: any[];
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init?: Partial<TableConfigs>);
}
