/**
 * Class Pagination
 */
export declare class Pagination {
    /**
     * set the pagination type
     *
     * pages - the data is presented page by page
     *
     * infiniteLoading - the data is presented with scroll
     */
    type: PaginationType;
    /**
     * number of items per page
     */
    totalRows: number;
    /**
     * options for choosing items per page(by pages)
     */
    rowsPerPageOptions: number[];
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init?: Partial<Pagination>);
}
export declare enum PaginationType {
    infiniteLoading = "infiniteLoading",
    pages = "pages"
}
