import { EventEmitter } from "@angular/core";
import { BehaviorSubject } from "rxjs";
/**
 * Used in PageContextService to keep each owner information
 */
export interface OwnerContext {
    /**
     * Keeps information of all owner variables.
     * <br />-> key - name of the variable
     * <br />-> value - observable that keeps the value of the variable
     */
    variables: Map<string, BehaviorSubject<any>>;
    /**
     * Keeps information of all owner actions.
     *  <br />-> key - name of the action
     *  <br />-> value - event emitter of the action
     */
    actions: Map<string, EventEmitter<any>>;
}
