import { FilterMatchMode } from 'primeng/api';
export declare enum FilterExpressions {
    And = 0,
    Or = 1
}
/**
 * Map primeng expressions to out expressions
 */
export declare const MapPrimeNgExpressionsToFilterExpressions: Map<string, FilterExpressions>;
export declare enum FilterOperations {
    EqualTo = 0,
    NotEqualTo = 1,
    GreaterThan = 2,
    GreaterThanOrEqualTo = 3,
    LessThan = 4,
    LessThanOrEqualTo = 5,
    Between = 6,
    Contains = 7,
    DoesNotContain = 8,
    EndsWith = 9,
    In = 10,
    IsEmpty = 11,
    IsNotEmpty = 12,
    IsNotNull = 13,
    IsNotNullNorWhiteSpace = 14,
    IsNull = 15,
    IsNullOrWhiteSpace = 16,
    StartsWith = 17,
    NotIn = 18
}
/**
 * Map primeng operations to out filter operations
 */
export declare const MapPrimeNgFilterOperationsToFilterOperations: Map<FilterMatchMode, FilterOperations>;
/**
 * enum to convert our datatypes to those supported by primeng
 */
export declare enum PrimeNgTypeToOurTypes {
    'dataType.string' = "text",
    'dataType.number' = "numeric",
    'dataType.date' = "date"
}
/**
 * Filter operations in string format
 */
export declare enum FilterOperationsString {
    'EqualTo' = 0,
    'NotEqualTo' = 1,
    'GreaterThan' = 2,
    'GreaterThanOrEqualTo' = 3,
    'LessThan' = 4,
    'LessThanOrEqualTo' = 5,
    'Between' = 6,
    'Contains' = 7,
    'DoesNotContain' = 8,
    'EndsWith' = 9,
    'In' = 10,
    'IsEmpty' = 11,
    'IsNotEmpty' = 12,
    'IsNotNull' = 13,
    'IsNotNullNorWhiteSpace' = 14,
    'IsNull' = 15,
    'IsNullOrWhiteSpace' = 16,
    'StartsWith' = 17,
    'NotIn' = 18
}
export declare enum OrderTypes {
    Ascending = 0,
    Descending = 1
}
/**
 * Map primeng sort order to ou orderTypes
 */
export declare const PrimeNgSortToOrderTypeMap: Map<number, OrderTypes>;
export declare class Filter {
    propertyName: string;
    value: any;
    value2: string;
    filterOperation: FilterOperations;
    filterExpression: FilterExpressions;
    startGroup: boolean;
}
export declare class Order {
    propertyName: string;
    orderType: OrderTypes;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<Order>);
}
export declare class FilterGroup {
    filterCollections: Filter[];
    orderCollection: Order[];
    pageSize: number | undefined;
    pageIndex: number | undefined;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<FilterGroup>);
}
export declare class FilterCollection {
    order: number;
    filter: Filter[];
}
export declare class GenericFilter {
    order: number;
    propertyName: string;
    placeholder: string;
    propertyType: string;
    propertyTranslation?: string;
    defaultValue?: any;
    possibleValues?: any[];
    propertyValue?: any;
    filterOperation: FilterOperations;
    filterExpression: FilterExpressions;
    lookupTableName?: string;
    isStartGroup: boolean;
    visible?: boolean;
}
