import { ReferenceType } from '../components/dynamic-form/models/constants/reference-type';
import { BaseEntity } from './base-entity.model';
/**
 * ConfigurationItem class that defines generic configurations
 */
export declare class ConfigurationItem extends BaseEntity {
    /**
     * Path that leads to the item (excluding itself)
     * <br />e.g. "Identity:SignIn"
     * <br />the node name is on the name property from BaseEntity
     */
    path: string;
    /**
     * Item value
     */
    value: string;
    /**
     * Item value type
     */
    dataType: string;
    /**
     * existing enum (looukup, entitytype)
     */
    referenceType: ReferenceType;
    /**
     * If type is lookup table, item
     * <br /> lookup table name
     */
    referenceName: string;
    /**
     * gui settings
     * @type {string}
     */
    guiSettings: string;
    /**
     * Item is system
     */
    isSystem: boolean;
    /**
     * Constructor
     * @param {Partial<ConfigurationItem>} init
     */
    constructor(init?: Partial<ConfigurationItem>);
}
