/**
 * BaseEntity class extended by most framework entities
 */
export declare abstract class BaseEntity {
    /**
     * Id
     */
    id: string;
    /**
     * Universal State lookup table item id (foreign key)
     */
    universalStateId: string;
    /**
     * Database transaction id
     */
    transactionId: string;
    /**
     * Database operation id
     */
    operationId: string;
    /**
     * Name
     */
    name: string;
    /**
     * Created by user id
     */
    createdBy: string;
    /**
     * Modified by (last) user id
     */
    modifiedBy: string;
    /**
     * Creation date
     */
    createdOn: Date;
    /**
     * Modification date
     */
    modifiedOn: Date;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<BaseEntity>);
}
export declare enum UniversalState {
    Inactive = "0",
    Active = "1"
}
