import { EventEmitter, OnInit } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { PrgEntityTypesConfig } from '../../../entity-types/models/prg-entity-types-config';
import { PrgMenuItem } from '../../../layouts/models/prg-menu-item';
import { ViewMode } from '../../models/constants/view-mode.enum';
import { FormGroupService } from '../../services/form-group/form-group.service';
import { UtilityService } from '../../services/utility/utility.service';
import { ActionOutput, BaseAction, DynamicFormActionOutput, DynamicFormFieldChangeOutput, FieldChangeOutput } from './models/base-action';
import { BaseField } from './models/base-field';
import * as i0 from "@angular/core";
/**
 * Dynamic form component
 */
export declare class PrgDynamicFormComponent implements OnInit {
    private objectsUtilityService;
    private arrayUtilityService;
    private formGroupService;
    private utilityService;
    private entityConfigs;
    /**
     * Tab menu items
     * @type {PrgMenuItem[]}
     */
    tabMenuItemsDynamicForm: PrgMenuItem[];
    /**
     * active tab menu
     */
    activeTabMenuItemsDynamicForm: PrgMenuItem;
    /**
     * Context of class where dynamic form component is used
     * @type {any}
     */
    context: any;
    /**
     * fields aux
     */
    private _fields;
    /**
     * fields aux
     */
    private _originalFields;
    /**
     *array with the fields
     */
    set fields(fields: BaseField[]);
    /**
     * get fields
     */
    get fields(): BaseField[];
    /**
     * actions aux
     */
    private _actions;
    /**
     *array with the actions
     */
    set actions(actions: BaseAction[]);
    /**
     * get actions
     */
    get actions(): BaseAction[];
    /**
     * entity aux
     */
    private _entity;
    /**
     * input entity
     */
    set entity(entity: any);
    /**
     * get entity
     */
    get entity(): any;
    /**
     * Temporary entity to access fields values when changes occur
     * @type {any}
     * @private
     */
    private _entityTemp;
    /**
     * getter entity temp
     * @returns {any}
     */
    get entityTemp(): any;
    /**
     * view mode aux
     */
    private _viewMode;
    /**
     * input view mode
     */
    set viewMode(viewMode: ViewMode);
    /**
     * get View Mode
     */
    get viewMode(): ViewMode;
    /**
     * The grouping type of the form
     * @type {any}
     */
    formGroupType: any;
    /**
     * action output
     */
    actionOutput: EventEmitter<DynamicFormActionOutput>;
    /**
     * Field output onChange
     * @type {EventEmitter<DynamicFormFieldChangeOutput>}
     */
    fieldChangeOutput: EventEmitter<DynamicFormFieldChangeOutput>;
    /**
     * declare form group
     */
    form: FormGroup;
    /**
     * left actions
     */
    leftActions: BaseAction[];
    /**
     * middle actions
     */
    middleActions: BaseAction[];
    /**
     * right actions
     */
    rightActions: BaseAction[];
    /**
     * constructor
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {FormGroupService} formGroupService
     * @param {UtilityService} utilityService
     * @param {PrgEntityTypesConfig} entityConfigs
     */
    constructor(objectsUtilityService: ObjectsUtilityService, arrayUtilityService: ArrayUtilityService, formGroupService: FormGroupService, utilityService: UtilityService, entityConfigs: PrgEntityTypesConfig);
    /**
     * ngOnInit
     */
    ngOnInit(): void;
    /**
     * this function divides the actions by their respective positions
     */
    private createActionsArray;
    /**
     * this function fire the output
     * @param action
     */
    onActionClicked(action: ActionOutput): void;
    /**
     * this function maps the new values in the entity
     */
    private mapFieldsToValue;
    /**
     * this function maps the entity values in the fields
     * @param entity
     */
    private mapValueToFields;
    /**
     * this function depending on the view mode changes the read only and disabled value
     */
    private fieldsReadonly;
    /**
     * this function calls the service that does the expression eval for fields
     * @param {string} expression
     * @param {boolean} defaultValue
     * @param {string | null} formFieldGroup
     * @returns {boolean}
     */
    evalExpression(expression: string, defaultValue?: boolean, formFieldGroup?: string | null): boolean;
    /**
     * this function fire the output for the fields
     * @param {FieldChangeOutput} field
     */
    onFieldChanged(field: FieldChangeOutput): void;
    /**
     * This function is responsible to change the active tab property of the class whenever a tab is change on form
     * @param event
     * @private
     */
    private onChangeTab;
    /**
     * This function construct the tab menu base on property groupFieldsId of the fields
     * @private
     */
    private createTabMenu;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgDynamicFormComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgDynamicFormComponent, "prg-dynamic-form", never, { "context": "context"; "fields": "fields"; "actions": "actions"; "entity": "entity"; "viewMode": "viewMode"; "formGroupType": "formGroupType"; }, { "actionOutput": "actionOutput"; "fieldChangeOutput": "fieldChangeOutput"; }, never, never, false>;
}
