import { ValidatorFn } from '@angular/forms';
/**
 * Class BaseField
 */
export declare class BaseField {
    /**
     * defines the element to be used
     * should be prg-input or prg-select
     * default is prg-input
     */
    controlName?: string;
    /**
     * value
     */
    value?: any;
    /**
     * read only
     */
    readonly?: boolean;
    /**
     * disabled
     */
    disabled?: boolean;
    /**
     * visible expression
     */
    visibleExpression?: string;
    /**
     * enable expression
     */
    enableExpression?: string;
    /**
     * mandatory field, is used like formcontrolname
     */
    key: string;
    /**
     * path to translation
     */
    basePathTranslation?: string;
    /**
     * array with validations
     *
     * @example
     *  validators: [Validators.required, Validators.minLength(6)],
     */
    validators?: ValidatorFn[];
    /**
     * Disabled output event
     * @type {boolean}
     */
    disabledOutputEvent?: boolean;
    /**
     * Property that identifies the group that aggregates multiple fields
     * @type {string}
     */
    groupFieldsId?: string;
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init?: Partial<BaseField>);
}
