import { ExecutedActionBehaviour } from '../../../models/executed-action-behaviourts';
/**
 * class action
 */
export declare class BaseAction {
    /**
     * defines the element to be used
     * default is button
     */
    controlName?: string;
    /**
     * with {@link #isDisabled} set to true we use this
     * field to enable or disable the button depending
     * on the validation state of the form
     */
    disableWhenFormInvalid?: boolean;
    /**
     *  action indicator, to be able to tell which action should be executed
     */
    key?: string;
    /**
     * translation base path
     */
    translationBasePath?: string;
    /**
     * this property is only relevant for actions that go into a
     * toolbar, it indicates the slot (position) in which the
     * action should be inserted
     *
     * options: end, start
     */
    toolbarSlot?: any;
    /**
     * value where the action will be executed
     */
    value?: any[];
    /**
     * visible expression
     */
    visibleExpression?: string;
    /**
     * enable expression
     */
    enableExpression?: string;
    /**
     * order
     */
    order: number;
    /**
     * executedActionBehaviour
     */
    executedActionBehaviour: ExecutedActionBehaviour;
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init?: Partial<BaseAction>);
}
/**
 * Action output
 */
export declare class ActionOutput {
    /**
     * action key
     */
    action?: string;
    /**
     * event
     * @type {any}
     */
    event?: any;
    /**
     * Group of a button to be able to identify them when an action happen on grouped action buttons
     * @type {string}
     */
    group?: string;
    /**
     * value
     */
    value?: any;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<ActionOutput>);
}
/**
 * Field output
 */
export declare class FieldChangeOutput {
    /**
     * field
     */
    field: string;
    /**
     * event
     */
    event: any;
    /**
     *value
     */
    value: any;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<FieldChangeOutput>);
}
/**
 * Dynamic Form Action output
 */
export declare class DynamicFormActionOutput extends ActionOutput {
    /**
     * entity resulting from the form
     */
    formEntity: any;
    /**
     * form status
     */
    formStatus: FormStatus;
    /**
     * form is changed
     */
    isChanged: boolean;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<DynamicFormActionOutput>);
}
/**
 * Dynamic Form Field Change output
 */
export declare class DynamicFormFieldChangeOutput extends FieldChangeOutput {
    /**
     * entity resulting from the form
     */
    formEntity: any;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<DynamicFormFieldChangeOutput>);
}
/**
 * Actions input type
 */
export declare enum ActionInputType {
    Submit = "submit",
    Cancel = "cancel",
    Reset = "reset",
    Delete = "delete",
    Linear = "linear"
}
/**
 * form status
 */
export declare enum FormStatus {
    Valid = "valid",
    Invalid = "invalid",
    Disabled = "disabled"
}
/**
 * base actions keys
 */
export declare enum BaseActionKey {
    Edit = "edit",
    Add = "add",
    Reset = "reset",
    Delete = "delete",
    Save = "save",
    Cancel = "cancel"
}
