import { EventEmitter } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { FieldChangeOutput } from '../models/base-action';
import { ControlName } from '../models/constants/control-names';
import * as i0 from "@angular/core";
/**
 * Dynamic form field component
 */
export declare class PrgDynamicFormFieldComponent {
    /**
     * receives a field
     */
    field: any;
    /**
     * receive the formGroup
     */
    form: FormGroup;
    /**
     * Emit a new FieldChangeOutput whenever a field value changes
     */
    onChange: EventEmitter<FieldChangeOutput>;
    /**
     * output to dynamic component
     */
    outputs: {
        onValueChange: (fieldChangeOutput: FieldChangeOutput) => void;
    };
    /**
     * fields type
     * @type {{inputNumber: PrgInputNumberComponent, inputTextArea: PrgInputTextAreaComponent, checkbox: PrgCheckboxComponent, inputText: PrgInputTextComponent, inputDateTime: PrgDateTimeComponent, inputPassword: PrgPasswordComponent, dropdown: PrgSelectComponent, multiSelect: PrgMultiSelectComponent}}
     */
    fieldTypes: {
        inputText: typeof import("./fields/input-text/input-text.component").PrgInputTextComponent;
        inputNumber: typeof import("./fields/input-number/input-number.component").PrgInputNumberComponent;
        inputDateTime: typeof import("./fields/input-date-time/date-time.component").PrgDateTimeComponent;
        inputPassword: typeof import("./fields/password/password.component").PrgPasswordComponent;
        dropdown: typeof import("./fields/select/select.component").PrgSelectComponent;
        multiSelect: typeof import("./fields/multiselect/multi-select.component").PrgMultiSelectComponent;
        checkbox: typeof import("./fields/checkbox/checkbox.component").PrgCheckboxComponent;
        inputTextArea: typeof import("./fields/input-text-area/input-text-area.component").PrgInputTextAreaComponent;
        triStateCheckbox: typeof import("./fields/tri-state-checkbox/tri-state-checkbox.component").PrgTriStateCheckboxComponent;
        selectButton: typeof import("./fields/select-button/select-button.component").PrgSelectButtonComponent;
        radioButton: typeof import("./fields/radio-button/radio-button.component").PrgRadioButtonComponent;
        colorPicker: typeof import("./fields/color-picker/color-picker.component").PrgColorPickerComponent;
        inputMask: typeof import("./fields/input-mask/input-mask.component").PrgInputMaskComponent;
        slider: typeof import("./fields/slider/slider.component").PrgSliderComponent;
        inputSwitch: typeof import("./fields/input-switch/input-switch.component").PrgInputSwitchComponent;
        rating: typeof import("./fields/rating/rating.component").PrgRatingComponent;
        knob: typeof import("./fields/knob/knob.component").PrgKnobComponent;
        chips: typeof import("./fields/chips/chips.component").PrgChipsComponent;
        toggleButton: typeof import("./fields/toggle-button/toggle-button.component").PrgToggleButtonComponent;
        listBox: typeof import("./fields/list-box/list-box.component").PrgListBoxComponent;
        cascadeSelect: typeof import("./fields/cascade-select/cascade-select..component").PrgCascadeSelectComponent;
        autoComplete: typeof import("./fields/auto-complete/auto-complete.component").PrgAutoCompleteComponent;
    };
    /**
     * @returns boolean if question is valid or not
     */
    get isValid(): boolean;
    /**
     * @returns string with error
     */
    get errors(): import("@angular/forms").ValidationErrors;
    /**
     * get control
     * @returns control
     */
    get formControl(): any;
    /**
     * get control name
     * @return controlname
     */
    get controlNames(): typeof ControlName;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgDynamicFormFieldComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgDynamicFormFieldComponent, "prg-dynamic-form-field", never, { "field": "field"; "form": "form"; }, { "onChange": "onChange"; }, never, never, false>;
}
