import { TriStateCheckbox } from 'primeng/tristatecheckbox';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class TriState Checkbox
 */
export declare class TriStateCheckboxConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     *Name of the component.
     */
    name: string;
    /**
     *Label of the checkbox.
     */
    label: string;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Identifier of the focus input to match a label defined for the component.
     */
    inputId: string;
    /**
     *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
     */
    ariaLabelledBy: string;
    /**
     *Inline style of the component.
     */
    style: object;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Specifies the icon for checkbox true value.
     */
    checkboxTrueIcon: string;
    /**
     *Specifies the icon for checkbox false value.
     */
    checkboxFalseIcon: string;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<TriStateCheckboxConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetTriStateCheckboxConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: TriStateCheckbox);
    /**
     * input Tri State Checkbox configs and assign configs to element
     */
    set setTriStateCheckboxConfigs(configs: TriStateCheckboxConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetTriStateCheckboxConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetTriStateCheckboxConfigsDirective, "[setTriStateCheckboxConfigs]", never, { "setTriStateCheckboxConfigs": "setTriStateCheckboxConfigs"; }, {}, never, never, false>;
}
