import { Slider } from 'primeng/slider';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Slider
 */
export declare class SliderConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     *When enabled, displays an animation on click of the slider bar.
     */
    animate: boolean;
    /**
     *Mininum boundary value.
     */
    min: number;
    /**
     *Maximum boundary value.
     */
    max: number;
    /**
     *Orientation of the slider, valid values are horizontal and vertical.
     */
    orientation: string;
    /**
     *Step factor to increment/decrement the value.
     */
    step: number;
    /**
     *When specified, allows two boundary values to be picked.
     */
    range: boolean;
    /**
     *Inline style of the component.
     */
    style: string;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
     */
    ariaLabelledBy: string;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<SliderConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetSliderConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: Slider);
    /**
     * input slider configs and assign configs to element
     */
    set setSliderConfigs(configs: SliderConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetSliderConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetSliderConfigsDirective, "[setSliderConfigs]", never, { "setSliderConfigs": "setSliderConfigs"; }, {}, never, never, false>;
}
