import { ChangeDetectorRef } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { Dropdown } from 'primeng/dropdown';
import { ScrollerOptions } from 'primeng/scroller';
import { AbstractEntityTypeService } from '../../../../../../entity-types/services/entity-types/abstract-entity-type.service';
import { AbstractLookupTableService } from '../../../../../../lookup-table/services/lookup-table/abstract-lookup-table.service';
import { ArrayUtilityService } from '../../../../../services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../../../services/utility/objects-utility.service';
import { BaseField } from '../../../models/base-field';
import { ReferenceType } from '../../../models/constants/reference-type';
import * as i0 from "@angular/core";
/**
 * Class Select
 */
export declare class SelectConfiguration extends BaseField {
    /**
     * control name
     */
    controlName: string;
    /**
     * Reference type
     */
    referenceType: ReferenceType;
    /**
     * Reference name -> shoud be a lookup table name
     */
    referenceName: string;
    /**
     *An array of objects to display as the available options.
     */
    options: any[];
    /**
     *Name of the label field of an option.
     */
    optionLabel: string;
    /**
     *Name of the value field of an option.
     */
    optionValue: string;
    /**
     *Name of the disabled field of an option.
     */
    optionDisabled: string;
    /**
     *Name of the label field of an option group.
     */
    optionGroupLabel: string;
    /**
     *Name of the options field of an option group.
     */
    optionGroupChildren: string;
    /**
     *Name of the input element.
     */
    name: string;
    /**
     *Height of the viewport in pixels, a scrollbar is defined if height of list exceeds this value.
     */
    scrollHeight: string;
    /**
     *Inline style of the element.
     */
    style: string;
    /**
     *Inline style of the overlay panel element.
     */
    panelStyle: string;
    /**
     *Style class of the element.
     */
    styleClass: string;
    /**
     *Style class of the overlay panel element.
     */
    panelStyleClass: string;
    /**
     *When specified, displays an input field to filter the items on keyup.
     */
    filter: boolean;
    /**
     *When specified, filter displays with this value.
     */
    filterValue: string;
    /**
     *When filtering is enabled, filterBy decides which field or fields (comma separated) to search against.
     */
    filterBy: string;
    /**
     *Defines how the items are filtered, valid values are contains (default) startsWith, endsWith, equals, notEquals, in, lt, lte, gt and gte.
     */
    filterMatchMode: string;
    /**
     *Placeholder text to show when filter input is empty.
     */
    filterPlaceholder: string;
    /**
     *Locale to use in filtering. The default locale is the host environment's current locale.
     */
    filterLocale: string;
    /**
     *When present, it specifies that an input field must be filled out before submitting the form.
     */
    required: boolean;
    /**
     *Text to display when there is no data. Defaults to global value in i18n translation configuration.
     */
    emptyMessage: string;
    /**
     *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
     */
    ariaLabelledBy: string;
    /**
     *When present, custom value instead of predefined options can be entered using the editable input field.
     */
    editable: boolean;
    /**
     *Maximum number of character allows in the editable input field.
     */
    maxlength: number;
    /**
     *Target element to attach the overlay, valid values are body or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]=mydiv for a div element having #mydiv as variable name).
     */
    appendTo: any;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Default text to display when no option is selected.
     */
    placeholder: string;
    /**
     *Identifier of the accessible input element.
     */
    inputId: string;
    /**
     *A property to uniquely identify a value in options.
     */
    dataKey: string;
    /**
     *When present, it specifies that the component should automatically get focus on load.
     */
    autofocus: boolean;
    /**
     *Applies focus to the filter element when the overlay is shown.
     */
    autofocusFilter: boolean;
    /**
     *Clears the filter value when hiding the dropdown.
     */
    resetFilterOnHide: boolean;
    /**
     *Icon class of the dropdown icon.
     */
    dropdownIcon: string;
    /**
     *Text to display when filtering does not return any results.
     */
    emptyFilterMessage: string;
    /**
     *Whether to display the first item as the label if no placeholder is defined and value is null.
     */
    autoDisplayFirst: boolean;
    /**
     *Whether to display options as grouped when nested options are provided.
     */
    group: boolean;
    /**
     *When enabled, a clear icon is displayed to clear the value.
     */
    showClear: boolean;
    /**
     *Base zIndex value to use in layering.
     */
    baseZIndex: number;
    /**
     *Whether to automatically manage layering.
     */
    autoZIndex: boolean;
    /**
     *Transition options of the show animation.
     */
    showTransitionOptions: string;
    /**
     *Transition options of the hide animation.
     */
    hideTransitionOptions: string;
    /**
     *Defines a string that labels the filter input.
     */
    ariaFilterLabel: string;
    /**
     *Used to define a string that autocomplete attribute the current element.
     */
    ariaLabel: string;
    /**
     *Advisory information to display in a tooltip on hover.
     */
    tooltip: any;
    /**
     *Style class of the tooltip.
     */
    tooltipStyleClass: string;
    /**
     *Position of the tooltip, valid values are right, left, top and bottom.
     */
    tooltipPosition: string;
    /**
     *Type of CSS position.
     */
    tooltipPositionStyle: string;
    /**
     *Whether the data should be loaded on demand during scroll.
     */
    virtualScroll: boolean;
    /**
     *Height of an item in the list for VirtualScrolling.
     */
    virtualScrollItemSize: number;
    /**
     *Whether to use the scroller feature. The properties of scroller component can be used like an object in it.
     */
    virtualScrollOptions: ScrollerOptions;
    /**
     *Defines if data is loaded and interacted with in lazy manner.
     */
    lazy: boolean;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<SelectConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetSelectConfigsDirective {
    private element;
    private lookupTableService;
    private entityTypeService;
    private cd;
    private arrayUtilityService;
    private objectsUtilityService;
    /**
     * constructor
     * @param {Dropdown} element
     * @param {AbstractLookupTableService} lookupTableService
     * @param {AbstractEntityTypeService} entityTypeService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(element: Dropdown, lookupTableService: AbstractLookupTableService, entityTypeService: AbstractEntityTypeService, cd: ChangeDetectorRef, arrayUtilityService: ArrayUtilityService, objectsUtilityService: ObjectsUtilityService);
    /**
     * form
     */
    form: FormGroup;
    /**
     * get options from lookup table or entity type list
     * and assign configs to element
     */
    set setSelectConfigs(configs: SelectConfiguration | any);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetSelectConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetSelectConfigsDirective, "[setSelectConfigs]", never, { "form": "form"; "setSelectConfigs": "setSelectConfigs"; }, {}, never, never, false>;
}
