import { SelectButton } from 'primeng/selectbutton';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Select Button
 */
export declare class SelectButtonConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     *An array of selectitems to display as the available options.
     */
    options: any[];
    /**
     *Name of the label field of an option.
     */
    optionLabel: string;
    /**
     *Name of the value field of an option.
     */
    optionValue: string;
    /**
     *Name of the disabled field of an option.
     */
    optionDisabled: string;
    /**
     *When specified, allows selecting multiple values.
     */
    multiple: boolean;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Inline style of the component.
     */
    style: string;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
     */
    ariaLabelledBy: string;
    /**
     *A property to uniquely identify a value in options.
     */
    dataKey: string;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<SelectButtonConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetSelectButtonConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: SelectButton);
    /**
     * input Select Button configs and assign configs to element
     */
    set setSelectButtonConfigs(configs: SelectButtonConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetSelectButtonConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetSelectButtonConfigsDirective, "[setSelectButtonConfigs]", never, { "setSelectButtonConfigs": "setSelectButtonConfigs"; }, {}, never, never, false>;
}
