import { Rating } from 'primeng/rating';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Rating
 */
export declare class RatingConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     *Number of stars.
     */
    stars: number;
    /**
     *When specified a cancel icon is displayed to allow removing the value.
     */
    cancel: boolean;
    /**
     *Style class of the on icon.
     */
    iconOnClass: string;
    /**
     *Style class of the off icon.
     */
    iconOffClass: string;
    /**
     *Style class of the cancel icon.
     */
    iconCancelClass: string;
    /**
     *Inline style of the on icon.
     */
    iconOnStyle: object;
    /**
     *Inline style of the off icon.
     */
    iconOffStyle: object;
    /**
     *Inline style of the cancel icon.
     */
    iconCancelStyle: object;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<RatingConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetRatingConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: Rating);
    /**
     * input Rating configs and assign configs to element
     */
    set setRatingConfigs(configs: RatingConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetRatingConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetRatingConfigsDirective, "[setRatingConfigs]", never, { "setRatingConfigs": "setRatingConfigs"; }, {}, never, never, false>;
}
