import { RadioButton } from 'primeng/radiobutton';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Radio Button
 */
export declare class RadioButtonConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     *Name of the radiobutton group.
     */
    name: string;
    /**
     *Value of the radiobutton.
     */
    value: any;
    /**
     *Label of the radiobutton.
     */
    label: string;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Identifier of the focus input to match a label defined for the component.
     */
    inputId: string;
    /**
     *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
     */
    ariaLabelledBy: string;
    /**
     *Used to define a string that labels the input element.
     */
    ariaLabel: string;
    /**
     *Inline style of the component.
     */
    style: object;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Style class of the label.
     */
    labelStyleClass: string;
    /**
     *An array of objects to display as dynamic values.Mandatory field.
     */
    options: any[];
    /**
     *Name of the value field of an option. Default 'value'.
     */
    optionValue: string;
    /**
     *Name of the key field of an option.Default 'key'.Also used to bring the translation of the field
     */
    optionKey: string;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<RadioButtonConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetRadioButtonConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: RadioButton);
    /**
     * input Radio Button configs and assign configs to element
     */
    set setRadioButtonConfigs(configs: RadioButtonConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetRadioButtonConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetRadioButtonConfigsDirective, "[setRadioButtonConfigs]", never, { "setRadioButtonConfigs": "setRadioButtonConfigs"; }, {}, never, never, false>;
}
