import { Password } from 'primeng/password';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Input Text
 */
export declare class InputPasswordConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     *Text to prompt password entry. Defaults to PrimeNG I18N API configuration.
     */
    promptLabel: string;
    /**
     *^(((?=.*[a-z])(?=.*[A-Z]))|((?=.*[a-z])(?=.*[0-9]))|((?=.*[A-Z])(?=.*[0-9])))(?=.{6,}).
     */
    mediumRegex: string;
    /**
     *^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.{8,})
     */
    strongRegex: string;
    /**
     *Text for a weak password. Defaults to PrimeNG I18N API configuration.
     */
    weakLabel: string;
    /**
     *Text for a medium password. Defaults to PrimeNG I18N API configuration.
     */
    mediumLabel: string;
    /**
     *Text for a strong password. Defaults to PrimeNG I18N API configuration.
     */
    strongLabel: string;
    /**
     *Whether to show the strength indicator or not.
     */
    feedback: boolean;
    /**
     *Whether to show an icon to display the password as plain text.
     */
    toggleMask: boolean;
    /**
     *Id of the element or body for document where the overlay should be appended to.
     */
    appendTo: string;
    /**
     *Inline style of the input field.
     */
    inputStyle: any;
    /**
     *Style class of the input field.
     */
    inputStyleClass: string;
    /**
     *Identifier of the accessible input element.
     */
    inputId: string;
    /**
     *Inline style of the component.
     */
    style: string;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Advisory information to display on input.
     */
    placeholder: string;
    /**
     *Label of the input for accessibility.
     */
    label: string;
    /**
     *Defines a string that labels the input for accessibility.
     */
    ariaLabel: string;
    /**
     *Specifies one or more IDs in the DOM that labels the input field.
     */
    ariaLabelledBy: string;
    /**
     *When enabled, a clear icon is displayed to clear the value.
     */
    showClear: boolean;
    /**
     * constructor
     * @param init init
     */
    constructor(init?: Partial<InputPasswordConfiguration>);
}
/**
 * Directive
 * */
export declare class PrgSetInputPasswordConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: Password);
    /**
     * input password configs and assign configs to element
     */
    set setInputPasswordConfigs(configs: InputPasswordConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetInputPasswordConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetInputPasswordConfigsDirective, "[setInputPasswordConfigs]", never, { "setInputPasswordConfigs": "setInputPasswordConfigs"; }, {}, never, never, false>;
}
