import { ChangeDetectorRef } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { MultiSelect } from 'primeng/multiselect';
import { ScrollerOptions } from 'primeng/scroller';
import { AbstractEntityTypeService } from '../../../../../../entity-types/services/entity-types/abstract-entity-type.service';
import { AbstractLookupTableService } from '../../../../../../lookup-table/services/lookup-table/abstract-lookup-table.service';
import { ArrayUtilityService } from '../../../../../services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../../../services/utility/objects-utility.service';
import { BaseField } from '../../../models/base-field';
import { ReferenceType } from '../../../models/constants/reference-type';
import * as i0 from "@angular/core";
/**
 * Class Input Text
 */
export declare class MultiSelectConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     * Reference type
     */
    referenceType: ReferenceType;
    /**
     * Reference name -> shoud be a lookup table name
     */
    referenceName: string;
    /**
     *Target element to attach the overlay, valid values are body or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]=mydiv for a div element having #mydiv as variable name).
     */
    appendTo: any;
    /**
     *Defines a string that labels the filter input.
     */
    ariaFilterLabel: string;
    /**
     *Label of the input for accessibility.
     */
    label: string;
    /**
     *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
     */
    ariaLabelledBy: string;
    /**
     *Applies focus to the filter element when the overlay is shown.
     */
    autofocusFilter: boolean;
    /**
     *Whether to automatically manage layering.
     */
    autoZIndex: boolean;
    /**
     *Base zIndex value to use in layering.
     */
    baseZIndex: number;
    /**
     *Label to display when there are no selections. Deprecated: Use placeholder instead.
     */
    defaultLabel: string;
    /**
     *A property to uniquely identify a value in options.
     */
    dataKey: string;
    /**
     *Whether to show labels of selected item labels or use default label.
     */
    displaySelectedLabel: boolean;
    /**
     *Icon class of the dropdown icon.
     */
    dropdownIcon: string;
    /**
     *Text to display when filtering does not return any results.
     */
    emptyFilterMessage: string;
    /**
     *When specified, displays an input field to filter the items on keyup.
     */
    filter: boolean;
    /**
     *Defines how the items are filtered, valid values are contains (default) startsWith, endsWith, equals, notEquals, in, lt, lte, gt and gte.
     */
    filterMatchMode: string;
    /**
     *When specified, filter displays with this value.
     */
    filterValue: string;
    /**
     *Locale to use in filtering. The default locale is the host environment's current locale.
     */
    filterLocale: string;
    /**
     *When filtering is enabled, filterBy decides which field or fields (comma separated) to search against.
     */
    filterBy: string;
    /**
     *Defines placeholder of the filter input.
     */
    filterPlaceHolder: string;
    /**
     *Transition options of the hide animation.
     */
    hideTransitionOptions: string;
    /**
     *Identifier of the focus input to match a label defined for the component.
     */
    inputId: string;
    /**
     *Decides how many selected item labels to show at most.
     */
    maxSelectedLabels: number;
    /**
     *Name of the input element.
     */
    name: string;
    /**
     *An array of objects to display as the available options.
     */
    options: any[];
    /**
     *Name of the label field of an option.
     */
    optionLabel: string;
    /**
     *Name of the value field of an option.
     */
    optionValue: string;
    /**
     *Name of the disabled field of an option.
     */
    optionDisabled: string;
    /**
     *Name of the label field of an option group.
     */
    optionGroupLabel: string;
    /**
     *Name of the options field of an option group.
     */
    optionGroupChildren: string;
    /**
     *Whether to display options as grouped when nested options are provided.
     */
    group: boolean;
    /**
     *Specifies the visibility of the options panel.
     */
    overlayVisible: boolean;
    /**
     *Inline style of the overlay panel.
     */
    panelStyle: object;
    /**
     *Label to display when there are no selections.
     */
    placeholder: string;
    /**
     *When present, it specifies that the component cannot be edited.
     */
    readonly: boolean;
    /**
     *Text to display when there is no data. Defaults to global value in i18n translation configuration.
     */
    emptyMessage: string;
    /**
     *Clears the filter value when hiding the dropdown.
     */
    resetFilterOnHide: boolean;
    /**
     *Height of the viewport in pixels, a scrollbar is defined if height of list exceeds this value.
     */
    scrollHeight: string;
    /**
     *Label to display after exceeding max selected labels e.g. ({0} items selected), defaults ellipsis keyword to indicate a text-overflow.
     */
    selectedItemsLabel: string;
    /**
     *Number of maximum options that can be selected.
     */
    selectionLimit: number;
    /**
     *Whether to show the header.
     */
    showHeader: boolean;
    /**
     *Transition options of the show animation.
     */
    showTransitionOptions: string;
    /**
     *Whether to show the checkbox at header to toggle all items at once.
     */
    showToggleAll: boolean;
    /**
     *Inline style of the element.
     */
    style: object;
    /**
     *Style class of the element.
     */
    styleClass: string;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Advisory information to display in a tooltip on hover.
     */
    tooltip: any;
    /**
     *Style class of the tooltip.
     */
    tooltipStyleClass: string;
    /**
     *Position of the tooltip, valid values are right, left, top and bottom.
     */
    tooltipPosition: string;
    /**
     *Type of CSS position.
     */
    tooltipPositionStyle: string;
    /**
     *When enabled, a clear icon is displayed to clear the value.
     */
    showClear: boolean;
    /**
     *Whether the data should be loaded on demand during scroll.
     */
    virtualScroll: boolean;
    /**
     *Height of an item in the list for VirtualScrolling.
     */
    virtualScrollItemSize: number;
    /**
     *Whether to use the scroller feature. The properties of scroller component can be used like an object in it.
     */
    virtualScrollOptions: ScrollerOptions;
    /**
     *Defines if data is loaded and interacted with in lazy manner.
     */
    lazy: boolean;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<MultiSelectConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetMultiselectConfigsDirective {
    private element;
    private lookupTableService;
    private entityTypeService;
    private cd;
    private arrayUtilityService;
    private objectsUtilityService;
    /**
     * constructor
     * @param {MultiSelect} element
     * @param {AbstractLookupTableService} lookupTableService
     * @param {AbstractEntityTypeService} entityTypeService
     * @param {ChangeDetectorRef} cd
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(element: MultiSelect, lookupTableService: AbstractLookupTableService, entityTypeService: AbstractEntityTypeService, cd: ChangeDetectorRef, arrayUtilityService: ArrayUtilityService, objectsUtilityService: ObjectsUtilityService);
    /**
     * form
     */
    form: FormGroup;
    /**
     * input multi select configs and assign configs to element
     */
    set setMultiSelectConfigs(configs: MultiSelectConfiguration | any);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetMultiselectConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetMultiselectConfigsDirective, "[setMultiSelectConfigs]", never, { "form": "form"; "setMultiSelectConfigs": "setMultiSelectConfigs"; }, {}, never, never, false>;
}
