import { ChangeDetectorRef } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { Listbox } from 'primeng/listbox';
import { AbstractEntityTypeService } from '../../../../../../entity-types/services/entity-types/abstract-entity-type.service';
import { AbstractLookupTableService } from '../../../../../../lookup-table/services/lookup-table/abstract-lookup-table.service';
import { ObjectsUtilityService } from '../../../../../services/utility/objects-utility.service';
import { BaseField } from '../../../models/base-field';
import { ReferenceType } from '../../../models/constants/reference-type';
import * as i0 from "@angular/core";
/**
 * Class List box
 */
export declare class ListBoxConfiguration extends BaseField {
    /**
     * control name
     */
    controlName: string;
    /**
     * Reference type
     */
    referenceType: ReferenceType;
    /**
     * Reference name -> shoud be a lookup table name
     */
    referenceName: string;
    /**
     *Defines a string that labels the filter input.
     */
    ariaFilterLabel: string;
    /**
     *When specified, allows selecting items with checkboxes.
     */
    checkbox: boolean;
    /**
     *A property to uniquely identify a value in options.
     */
    dataKey: string;
    /**
     *When specified, displays a filter input at header.
     */
    filter: boolean;
    /**
     *Defines how the items are filtered, valid values are "contains" (default) "startsWith", "endsWith", "equals", "notEquals", "in", "lt", "lte", "gt" and "gte".
     */
    filterMatchMode: string;
    /**
     *When specified, filter displays with this value.
     */
    filterValue: string;
    /**
     *Locale to use in filtering. The default locale is the host environment's current locale.
     */
    filterLocale: string;
    /**
     *When filtering is enabled, filterBy decides which field or fields (comma separated) to search against.
     */
    filterBy: string;
    /**
     *Defines placeholder of the filter input.
     */
    filterPlaceHolder: string;
    /**
     *Inline style of the list element.
     */
    listStyle: string;
    /**
     *Style class of the list element.
     */
    listStyleClass: string;
    /**
     *Defines how multiple items can be selected, when true metaKey needs to be pressed to select or unselect an item and when set to false selection of each item can be toggled individually. On touch enabled devices, metaKeySelection is turned off automatically.
     */
    metaKeySelection: boolean;
    /**
     *When specified, allows selecting multiple values.
     */
    multiple: boolean;
    /**
     *Text to display when there is no data. Defaults to global value in i18n translation configuration.
     */
    emptyMessage: string;
    /**
     *Text to display when filtering does not return any results. Defaults to global value in i18n translation configuration.
     */
    emptyFilterMessage: string;
    /**
     *An array of selectitems to display as the available options.
     */
    options: any[];
    /**
     *Name of the label field of an option.
     */
    optionLabel: string;
    /**
     *Name of the value field of an option.
     */
    optionValue: string;
    /**
     *Name of the disabled field of an option.
     */
    optionDisabled: string;
    /**
     *Name of the label field of an option group.
     */
    optionGroupLabel: string;
    /**
     *Name of the options field of an option group.
     */
    optionGroupChildren: string;
    /**
     *Whether to display options as grouped when nested options are provided.
     */
    group: boolean;
    /**
     *Whether header checkbox is shown in multiple mode.
     */
    showToggleAll: boolean;
    /**
     *Inline style of the container.
     */
    style: string;
    /**
     *Style class of the container.
     */
    styleClass: string;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<ListBoxConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetListBoxConfigsDirective {
    private element;
    private lookupTableService;
    private entityTypeService;
    private objectsUtilityService;
    private cdc;
    /**
     * Constructor
     * @param {Listbox} element
     * @param {AbstractLookupTableService} lookupTableService
     * @param {AbstractEntityTypeService} entityTypeService
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ChangeDetectorRef} cdc
     */
    constructor(element: Listbox, lookupTableService: AbstractLookupTableService, entityTypeService: AbstractEntityTypeService, objectsUtilityService: ObjectsUtilityService, cdc: ChangeDetectorRef);
    /**
     * form
     */
    form: FormGroup;
    /**
     * get options from lookup table or entity type list
     * and assign configs to element
     */
    set setListBoxConfigs(configs: ListBoxConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetListBoxConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetListBoxConfigsDirective, "[setListBoxConfigs]", never, { "form": "form"; "setListBoxConfigs": "setListBoxConfigs"; }, {}, never, never, false>;
}
