import { Knob } from 'primeng/knob';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Knob
 */
export declare class KnobConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     *Size of the component in pixels.
     */
    size: number;
    /**
     *Step factor to increment/decrement the value.
     */
    step: number;
    /**
     *Mininum boundary value.
     */
    min: number;
    /**
     *Maximum boundary value.
     */
    max: number;
    /**
     *Background of the value.
     */
    valueColor: string;
    /**
     *Background color of the range.
     */
    rangeColor: number;
    /**
     *Color of the value text.
     */
    textColor: number;
    /**
     *Width of the knob stroke.
     */
    strokeWidth: number;
    /**
     *Whether the show the value inside the knob.
     */
    showValue: boolean;
    /**
     *Template string of the value.
     */
    valueTemplate: string;
    /**
     *Inline style of the component.
     */
    style: object;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<KnobConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetKnobConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: Knob);
    /**
     * input Knob configs and assign configs to element
     */
    set setKnobConfigs(configs: KnobConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetKnobConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetKnobConfigsDirective, "[setKnobConfigs]", never, { "setKnobConfigs": "setKnobConfigs"; }, {}, never, never, false>;
}
