import { EventEmitter } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { UtilityService } from '../../../../../services/utility/utility.service';
import { FieldChangeOutput } from '../../../models/base-action';
import { InputTextConfiguration } from './input-text.model';
import * as i0 from "@angular/core";
/**
 * component input text
 */
export declare class PrgInputTextComponent {
    private utilityService;
    /**
     * input text configs
     */
    configs: InputTextConfiguration;
    /**
     * form
     */
    form: FormGroup;
    /**
     * output
     */
    onValueChange: EventEmitter<FieldChangeOutput>;
    /**
     * Constructor
     * @param {UtilityService} utilityService
     */
    constructor(utilityService: UtilityService);
    /**
     * function that triggers the output
     */
    onChanged(event: any): void;
    /**
     * Debounced method onChanged
     * @type {(args?: any) => void}
     */
    debounceOnChanged: (args?: any) => void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgInputTextComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgInputTextComponent, "prg-input-text-field", never, { "configs": "configs"; "form": "form"; }, { "onValueChange": "onValueChange"; }, never, never, false>;
}
