import { EventEmitter } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { UtilityService } from '../../../../../services/utility/utility.service';
import { FieldChangeOutput } from '../../../models/base-action';
import { InputTextAreaConfiguration } from './input-text-area.model';
import * as i0 from "@angular/core";
/**
 * component input text area
 */
export declare class PrgInputTextAreaComponent {
    private utilityService;
    /**
     * input text area configs
     */
    configs: InputTextAreaConfiguration;
    /**
     * form
     */
    form: FormGroup;
    /**
     * output
     */
    onValueChange: EventEmitter<FieldChangeOutput>;
    /**
     * Constructor
     * @param {UtilityService} utilityService
     */
    constructor(utilityService: UtilityService);
    /**
     * function that triggers the output
     */
    onChanged(event: any): void;
    /**
     * Debounced method onChanged
     * @type {(args?: any) => void}
     */
    debounceOnChanged: (args?: any) => void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgInputTextAreaComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgInputTextAreaComponent, "prg-input-text-area-field", never, { "configs": "configs"; "form": "form"; }, { "onValueChange": "onValueChange"; }, never, never, false>;
}
