import { InputSwitch } from 'primeng/inputswitch';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Input Switch
 */
export declare class InputSwitchConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     *Inline style of the component.
     */
    style: string;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Identifier of the input element.
     */
    inputId: string;
    /**
     *Name of the input element.
     */
    name: string;
    /**
     *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
     */
    ariaLabelledBy: string;
    /**
     *Value in checked state.
     */
    trueValue: any;
    /**
     *Value in unchecked state.
     */
    falseValue: any;
    /**
     *Used to define a string that autocomplete attribute the current element.
     */
    ariaLabel: string;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<InputSwitchConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetInputSwitchConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: InputSwitch);
    /**
     * Input Switch configs and assign configs to element
     */
    set setInputSwitchConfigs(configs: InputSwitchConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetInputSwitchConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetInputSwitchConfigsDirective, "[setInputSwitchConfigs]", never, { "setInputSwitchConfigs": "setInputSwitchConfigs"; }, {}, never, never, false>;
}
