import { InputNumber } from 'primeng/inputnumber';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Input Fiels
 */
export declare class InputNumberConfiguration extends BaseField {
    /**
     * control name
     */
    controlName: string;
    /**
     *Whether to format the value.
     */
    format: boolean;
    /**
     *Displays spinner buttons.
     */
    showButtons: boolean;
    /**
     *Layout of the buttons, valid values are stacked (default), horizontal and vertical.
     */
    buttonLayout: string;
    /**
     *Style class of the increment button.
     */
    incrementButtonClass: string;
    /**
     *Style class of the decrement button.
     */
    decrementButtonClass: string;
    /**
     *Style class of the increment button.
     */
    incrementButtonIcon: string;
    /**
     *Style class of the decrement button.
     */
    decrementButtonIcon: string;
    /**
     *Locale to be used in formatting.
     */
    locale: string;
    /**
     *The locale matching algorithm to use. Possible values are lookup and best fit; the default is best fit. See Locale Negotation for details.
     */
    localeMatcher: string;
    /**
     *Defines the behavior of the component, valid values are decimal and currency.
     */
    mode: string;
    /**
     *Text to display before the value.
     */
    prefix: string;
    /**
     *Text to display after the value.
     */
    suffix: string;
    /**
     *The currency to use in currency formatting. Possible values are the ISO 4217 currency codes, such as USD for the US dollar, EUR for the euro, or CNY for the Chinese RMB. There is no default value; if the style is currency, the currency property must be provided.
     */
    currency: string;
    /**
     *How to display the currency in currency formatting. Possible values are symbol to use a localized currency symbol such as €, ücode to use the ISO currency code, name to use a localized currency name such as dollar; the default is symbol.
     */
    currencyDisplay: string;
    /**
     *Whether to use grouping separators, such as thousands separators or thousand/lakh/crore separators.
     */
    useGrouping: boolean;
    /**
     *The minimum number of fraction digits to use. Possible values are from 0 to 20; the default for plain number and percent formatting is 0; the default for currency formatting is the number of minor unit digits provided by the ISO 4217 currency code list (2 if the list doesn't provide that information).
     */
    minFractionDigits: number;
    /**
     *The maximum number of fraction digits to use. Possible values are from 0 to 20; the default for plain number formatting is the larger of minimumFractionDigits and 3; the default for currency formatting is the larger of minimumFractionDigits and the number of minor unit digits provided by the ISO 4217 currency code list (2 if the list doesn't provide that information).
     */
    maxFractionDigits: number;
    /**
     *Mininum boundary value.
     */
    min: number;
    /**
     *Maximum boundary value.
     */
    max: number;
    /**
     *Step factor to increment/decrement the value.
     */
    step: number;
    /**
     *Determines whether the input field is empty.
     */
    allowEmpty: boolean;
    /**
     *Inline style of the component.
     */
    style: string;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Identifier of the focus input to match a label defined for the component.
     */
    inputId: string;
    /**
     *Inline style of the input field.
     */
    inputStyle: string;
    /**
     *Style class of the input field.
     */
    inputStyleClass: string;
    /**
     *Advisory information to display on input.
     */
    /**
     *Size of the input field.
     */
    size: number;
    /**
     *Maximum number of character allows in the input field.
     */
    maxlength: number;
    /**
     *Specifies tab order of the element.
     */
    tabindex: string;
    /**
     *When present, it specifies that an input field is read-only.
     */
    /**
     *Title text of the input text.
     */
    title: string;
    /**
     *Used to define a string that labels the input element.
     */
    ariaLabel: string;
    /**
     *Used to indicate that user input is required on an element before a form can be submitted.
     */
    ariaRequired: boolean;
    /**
     *Name of the input field.
     */
    /**
     *Used to define a string that autocomplete attribute the current element.
     */
    autocomplete: string;
    /**
     *When enabled, a clear icon is displayed to clear the value.
     */
    showClear: boolean;
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init?: Partial<InputNumberConfiguration>);
}
/**
 * directive
 */
export declare class PrgSetInputNumberConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: InputNumber);
    /**
     * input number configs and assign configs to element
     */
    set setInputNumberConfigs(configs: InputNumberConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetInputNumberConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetInputNumberConfigsDirective, "[setInputNumberConfigs]", never, { "setInputNumberConfigs": "setInputNumberConfigs"; }, {}, never, never, false>;
}
