import { InputMask } from 'primeng/inputmask';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Input Mask
 */
export declare class InputMaskConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     *HTML5 input type
     */
    type: string;
    /**
     *Mask pattern.
     */
    mask: string;
    /**
     *Placeholder character in mask, default is underscore.
     */
    slotChar: string;
    /**
     *Clears the incomplete value on blur.
     */
    autoClear: boolean;
    /**
     *Defines if ngModel sets the raw unmasked value to bound value or the formatted mask value.
     */
    unmask: boolean;
    /**
     *Inline style of the input field.
     */
    style: string;
    /**
     *Style class of the input field.
     */
    styleClass: string;
    /**
     *Advisory information to display on input.
     */
    placeholder: string;
    /**
     *Size of the input field.
     */
    size: number;
    /**
     *Maximum number of character allows in the input field.
     */
    maxlength: number;
    /**
     *Specifies tab order of the element.
     */
    tabindex: number;
    /**
     *Name of the input field.
     */
    name: string;
    /**
     *Identifier of the focus input to match a label defined for the component.
     */
    inputId: string;
    /**
     *When present, it specifies that an input field must be filled out before submitting the form.
     */
    required: boolean;
    /**
     *Regex pattern for alpha characters
     */
    characterPattern: string;
    /**
     *When present, the input gets a focus automatically on load.
     */
    autoFocus: boolean;
    /**
     *When enabled, a clear icon is displayed to clear the value.
     */
    showClear: boolean;
    /**
     *Used to define a string that autocomplete attribute the current element.
     */
    autocomplete: string;
    /**
     *Used to define a string that labels the input element.
     */
    ariaLabel: string;
    /**
     *Used to indicate that user input is required on an element before a form can be submitted.
     */
    ariaRequired: boolean;
    /**
     *Title text of the input text.
     */
    title: string;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<InputMaskConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetInputMaskConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: InputMask);
    /**
     * input Input Mask configs and assign configs to element
     */
    set setInputMaskConfigs(configs: InputMaskConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetInputMaskConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetInputMaskConfigsDirective, "[setInputMaskConfigs]", never, { "setInputMaskConfigs": "setInputMaskConfigs"; }, {}, never, never, false>;
}
