import { Calendar } from 'primeng/calendar';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Input Text
 */
export declare class DateTimeConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     *Set the date to highlight on first opening if the field is blank.
     */
    defaultDate: Date;
    /**
     *Defines the quantity of the selection, valid values are single, multiple and range.
     */
    selectionMode: string;
    /**
     *Inline style of the component.
     */
    style: string;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Inline style of the input field.
     */
    inputStyle: string;
    /**
     *Style class of the input field.
     */
    inputStyleClass: string;
    /**
     *Identifier of the focus input to match a label defined for the component.
     */
    inputId: string;
    /**
     *Name of the input element.
     */
    /**
     *Format of the date which can also be defined at locale settings.
     */
    dateFormat: string;
    /**
     *When enabled, displays the calendar as inline. Default is false for popup mode.
     */
    inline: boolean;
    /**
     *Whether to display dates in other months (non-selectable) at the start or end of the current month. To make these days selectable use the selectOtherMonths option.
     */
    showOtherMonths: boolean;
    /**
     *Whether days in other months shown before or after the current month are selectable. This only applies if the showOtherMonths option is set to true.
     */
    selectOtherMonths: boolean;
    /**
     *When enabled, displays a button with icon next to input.
     */
    showIcon: boolean;
    /**
     *When disabled, datepicker will not be visible with input focus.
     */
    showOnFocus: boolean;
    /**
     *When enabled, calendar will show week numbers.
     */
    showWeek: boolean;
    /**
     *Icon of the calendar button.
     */
    icon: string;
    /**
     *Target element to attach the overlay, valid values are body or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]=mydiv for a div element having #mydiv as variable name).
     */
    appendTo: any;
    /**
     *When specified, prevents entering the date manually with keyboard.
     */
    readonlyInput: boolean;
    /**
     *The cutoff year for determining the century for a date.
     */
    shortYearCutoff: string;
    /**
     *The minimum selectable date.
     */
    minDate: Date;
    /**
     *The maximum selectable date.
     */
    maxDate: Date;
    /**
     *Array with dates that should be disabled (not selectable).
     */
    disabledDates: Array<Date>;
    /**
     *Array with weekday numbers that should be disabled (not selectable).
     */
    disabledDays: Array<number>;
    /**
     *Whether the month should be rendered as a dropdown instead of text.
     */
    monthNavigator: boolean;
    /**
     *Whether the year should be rendered as a dropdown instead of text.
     */
    yearNavigator: boolean;
    /**
     *The range of years displayed in the year drop-down in (nnnn:nnnn) format such as (2000:2020).
     */
    yearRange: string;
    /**
     *Whether to display timepicker.
     */
    showTime: boolean;
    /**
     *Specifies 12 or 24 hour format.
     */
    hourFormat: string;
    /**
     *Whether to display timepicker only.
     */
    timeOnly: boolean;
    /**
     *Separator of time selector.
     */
    timeSeparator: string;
    /**
     *Type of the value to write back to ngModel, default is date and alternative is string.
     */
    dataType: string;
    /**
     *When present, it specifies that an input field must be filled out before submitting the form.
     */
    required: boolean;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
     */
    ariaLabelledBy: string;
    /**
     *Defines a string that labels the icon button for accessibility.
     */
    iconAriaLabel: string;
    /**
     *Whether to show the seconds in time picker.
     */
    showSeconds: boolean;
    /**
     *Hours to change per step.
     */
    stepHour: number;
    /**
     *Minutes to change per step.
     */
    stepMinute: number;
    /**
     *Seconds to change per step.
     */
    stepSecond: number;
    /**
     *Maximum number of selectable dates in multiple mode.
     */
    maxDateCount: number;
    /**
     *Whether to display today and clear buttons at the footer
     */
    showButtonBar: boolean;
    /**
     *Style class of the today button.
     */
    todayButtonStyleClass: string;
    /**
     *Style class of the clear button.
     */
    clearButtonStyleClass: string;
    /**
     *Base zIndex value to use in layering.
     */
    baseZIndex: number;
    /**
     *Whether to automatically manage layering.
     */
    autoZIndex: boolean;
    /**
     *Style class of the datetimepicker container element.
     */
    panelStyleClass: string;
    /**
     *Inline style of the datetimepicker container element.
     */
    panelStyle: object;
    /**
     *Keep invalid value when input blur.
     */
    keepInvalid: boolean;
    /**
     *Whether to hide the overlay on date selection.
     */
    hideOnDateTimeSelect: boolean;
    /**
     *Number of months to display.
     */
    numberOfMonths: number;
    /**
     *Type of view to display, valid values are date for datepicker and month for month picker.
     */
    view: 'date' | 'month' | 'year';
    /**
     *Separator for multiple selection mode.
     */
    multipleSeparator: string;
    /**
     *Separator for joining start and end dates on range selection mode.
     */
    rangeSeparator: string;
    /**
     *When enabled, calendar overlay is displayed as optimized for touch devices.
     */
    touchUI: boolean;
    /**
     *When enabled, can only focus on elements inside the calendar.
     */
    focusTrap: boolean;
    /**
     *Transition options of the show animation.
     */
    showTransitionOptions: string;
    /**
     *Transition options of the hide animation.
     */
    hideTransitionOptions: string;
    /**
     *Defines the first of the week for various date calculations.
     */
    firstDayOfWeek: number;
    /**
     *When enabled, a clear icon is displayed to clear the value.
     */
    showClear: boolean;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<DateTimeConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetDateTimeConfigsDirective {
    private cal;
    /**
     * constructor
     * @param cal
     */
    constructor(cal: Calendar);
    /**
     * input data time configs and assign configs to element
     */
    set setDateTimeConfigs(configs: DateTimeConfiguration | any);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetDateTimeConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetDateTimeConfigsDirective, "[setDateTimeConfigs]", never, { "setDateTimeConfigs": "setDateTimeConfigs"; }, {}, never, never, false>;
}
