import { ColorPicker } from 'primeng/colorpicker';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Color Picker
 */
export declare class ColorPickerConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     *Inline style of the component.
     */
    style: string;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Whether to display as an overlay or not.
     */
    inline: boolean;
    /**
     *Format to use in value binding, supported formats are "hex", "rgb" and "hsb".
     */
    format: string;
    /**
     *Target element to attach the overlay, valid values are "body" or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]="mydiv" for a div element having #mydiv as variable name).
     */
    appendTo: any;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Identifier of the focus input to match a label defined for the dropdown.
     */
    inputId: string;
    /**
     *Base zIndex value to use in layering.
     */
    baseZIndex: number;
    /**
     *Whether to automatically manage layering.
     */
    autoZIndex: boolean;
    /**
     *Transition options of the show animation.
     */
    showTransitionOptions: string;
    /**
     *Transition options of the hide animation.
     */
    hideTransitionOptions: string;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<ColorPickerConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetColorPickerConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: ColorPicker);
    /**
     * input Color Picker configs and assign configs to element
     */
    set setColorPickerConfigs(configs: ColorPickerConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetColorPickerConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetColorPickerConfigsDirective, "[setColorPickerConfigs]", never, { "setColorPickerConfigs": "setColorPickerConfigs"; }, {}, never, never, false>;
}
