import { Chips } from 'primeng/chips';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Chips
 */
export declare class ChipsConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     *Name of the property to display on a chip.
     */
    field: string;
    /**
     *Maximum number of entries allowed.
     */
    max: number;
    /**
     *Inline style of the element.
     */
    style: string;
    /**
     *Style class of the element.
     */
    styleClass: string;
    /**
     *Advisory information to display on input.
     */
    placeholder: string;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Identifier of the focus input to match a label defined for the component.
     */
    inputId: string;
    /**
     *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
     */
    ariaLabelledBy: string;
    /**
     *Whether to allow duplicate values or not.
     */
    allowDuplicate: boolean;
    /**
     *Inline style of the input field.
     */
    inputStyle: string;
    /**
     *Style class of the input field.
     */
    inputStyleClass: string;
    /**
     *Whether to add an item on tab key press.
     */
    addOnTab: boolean;
    /**
     *Whether to add an item when the input loses focus.
     */
    addOnBlur: boolean;
    /**
     *Separator char to add an item when pressed in addition to the enter key. Currently only possible value is ","
     */
    separator: string;
    /**
     *When enabled, a clear icon is displayed to clear the value.
     */
    showClear: boolean;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<ChipsConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetChipsConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: Chips);
    /**
     * input Chips configs and assign configs to element
     */
    set setChipsConfigs(configs: ChipsConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetChipsConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetChipsConfigsDirective, "[setChipsConfigs]", never, { "setChipsConfigs": "setChipsConfigs"; }, {}, never, never, false>;
}
