import { Checkbox } from 'primeng/checkbox';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class CheckBox
 */
export declare class CheckboxConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     *Name of the checkbox group.
     */
    name: string;
    /**
     *Label of the checkbox.
     */
    label: string;
    /**
     *Allows to select a boolean value instead of multiple values.
     */
    binary: boolean;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Identifier of the focus input to match a label defined for the component.
     */
    inputId: string;
    /**
     *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
     */
    ariaLabelledBy: string;
    /**
     *Used to define a string that labels the input element.
     */
    ariaLabel: string;
    /**
     *Inline style of the component.
     */
    style: object;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Style class of the label.
     */
    labelStyleClass: string;
    /**
     *Icon class of the checkbox icon.
     */
    checkboxIcon: string;
    /**
     *When present, it specifies that checkbox must be checked before submitting the form.
     */
    required: boolean;
    /**
     *Value in checked state.
     */
    trueValue: any;
    /**
     *Value in unchecked state.
     */
    falseValue: any;
    /**
     *An array of objects to display as dynamic values.Mandatory field.
     */
    options: any[];
    /**
     *Name of the value field of an option. Default 'value'.
     */
    optionValue: string;
    /**
     *Name of the key field of an option.Default 'key'.Also used to bring the translation of the field
     */
    optionKey: string;
    /**
     * Allow multiple checkbox selection. On false , whenever a checkbox is checked the others became disabled.
     */
    allowMultipleCheckBoxSelection: boolean;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<CheckboxConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetCheckboxConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: Checkbox);
    /**
     * input checkbox configs and assign configs to element
     */
    set setCheckboxConfigs(configs: CheckboxConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetCheckboxConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetCheckboxConfigsDirective, "[setCheckboxConfigs]", never, { "setCheckboxConfigs": "setCheckboxConfigs"; }, {}, never, never, false>;
}
