import { CascadeSelect } from 'primeng/cascadeselect';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Cascade Select
 */
export declare class CascadeSelectConfiguration extends BaseField {
    /**
     * control name
     */
    controlName: string;
    /**
     *An array of selectitems to display as the available options.
     */
    options: any[];
    /**
     *Property name or getter function to use as the label of an option.
     */
    optionLabel: string;
    /**
     *Property name or getter function to use as the value of an option, defaults to the option itself when not defined.
     */
    optionValue: string;
    /**
     *Property name or getter function to use as the label of an option group.
     */
    optionGroupLabel: string;
    /**
     *Property name or getter function to retrieve the items of a group.
     */
    optionGroupChildren: any[];
    /**
     *Default text to display when no option is selected.
     */
    placeholder: string;
    /**
     *When present, it specifies that the component should be disabled.
     */
    disabled: boolean;
    /**
     *A property to uniquely identify an option.
     */
    dataKey: string;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Identifier of the underlying input element.
     */
    inputId: string;
    /**
     *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
     */
    ariaLabelledBy: string;
    /**
     *Id of the element or "body" for document where the overlay should be appended to.
     */
    appendTo: string;
    /**
     *Inline style of the component.
     */
    style: object;
    /**
     *Inline style of the overlay panel.
     */
    panelStyle: object;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Style class of the overlay panel.
     */
    panelStyleClass: string;
    /**
     *Label of the input for accessibility.
     */
    inputLabel: string;
    /**
     *Defines a string that labels the input for accessibility.
     */
    ariaLabel: string;
    /**
     *When enabled, a clear icon is displayed to clear the value.
     */
    showClear: boolean;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<CascadeSelectConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetCascadeSelectConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: CascadeSelect);
    /**
     * input Cascade Selected configs and assign configs to element
     */
    set setCascadeSelectConfigs(configs: CascadeSelectConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetCascadeSelectConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetCascadeSelectConfigsDirective, "[setCascadeSelectConfigs]", never, { "setCascadeSelectConfigs": "setCascadeSelectConfigs"; }, {}, never, never, false>;
}
