import { AutoComplete } from 'primeng/autocomplete';
import { ScrollerOptions } from 'primeng/scroller';
import { BaseField } from '../../../models/base-field';
import * as i0 from "@angular/core";
/**
 * Class Auto Complete
 */
export declare class AutoCompleteConfiguration extends BaseField {
    /**
     * control name
     */
    controlName?: string;
    /**
     * An array of data to perform a search for autocomplete purpose
     */
    dataToSearch?: any[];
    /**
     *An array of suggestions to display.
     */
    suggestions: any[];
    /**
     *Field of a suggested object to resolve and display.
     */
    field: any;
    /**
     *Maximum height of the suggestions panel.
     */
    scrollHeight: string;
    /**
     *Displays a button next to the input field when enabled.
     */
    dropdown: boolean;
    /**
     *Specifies if multiple values can be selected.
     */
    multiple: boolean;
    /**
     *Icon class of the dropdown icon.
     */
    dropdownIcon: string;
    /**
     *Minimum number of characters to initiate a search.
     */
    minLength: number;
    /**
     *Delay between keystrokes to wait before sending a query.
     */
    delay: number;
    /**
     *Whether to run a query when input receives focus.
     */
    completeOnFocus: boolean;
    /**
     *Inline style of the component.
     */
    style: string;
    /**
     *Inline style of the input field.
     */
    inputStyle: string;
    /**
     *Inline style of the overlay panel element.
     */
    panelStyle: string;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Inline style of the input field.
     */
    inputStyleClass: string;
    /**
     *Style class of the overlay panel element.
     */
    panelStyleClass: string;
    /**
     *Identifier of the focus input to match a label defined for the component.
     */
    inputId: string;
    /**
     *Name of the input element.
     */
    name: string;
    /**
     *Name of the label field of an option group.
     */
    optionGroupLabel: string;
    /**
     *Whether to display options as grouped when nested options are provided.
     */
    group: boolean;
    /**
     *Name of the options field of an option group.
     */
    optionGroupChildren: string;
    /**
     *Hint text for the input field.
     */
    placeholder: string;
    /**
     *Maximum number of character allows in the input field.
     */
    maxlength: number;
    /**
     *Size of the input field.
     */
    size: number;
    /**
     *Target element to attach the overlay, valid values are "body" or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]="mydiv" for a div element having #mydiv as variable name).
     */
    appendTo: any;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *A property to uniquely identify a value in options.
     */
    dataKey: string;
    /**
     *When enabled, highlights the first item in the list by default.
     */
    autoHighlight: boolean;
    /**
     *Type of the input, defaults to "text".
     */
    type: string;
    /**
     *Whether to show the empty message or not.
     */
    showEmptyMessage: boolean;
    /**
     *Text to display when there is no data. Defaults to global value in i18n translation configuration.
     */
    emptyMessage: string;
    /**
     *Defines how the suggestions should be manipulated. More information is available at "Change Detection" section above.
     */
    immutable: boolean;
    /**
     *When present, it specifies that an input field must be filled out before submitting the form.
     */
    required: boolean;
    /**
     *When present, it specifies that the component should automatically get focus on load.
     */
    autofocus: boolean;
    /**
     *When present, autocomplete clears the manual input if it does not match of the suggestions to force only accepting values from the suggestions.
     */
    forceSelection: boolean;
    /**
     *Specifies the behavior dropdown button. Default "blank" mode sends an empty string and "current" mode sends the input value.
     */
    dropdownMode: string;
    /**
     *Base zIndex value to use in layering.
     */
    baseZIndex: number;
    /**
     *Whether to automatically manage layering.
     */
    autoZIndex: boolean;
    /**
     *Transition options of the show animation.
     */
    showTransitionOptions: string;
    /**
     *Transition options of the hide animation.
     */
    hideTransitionOptions: string;
    /**
     *Defines a string that labels the input for accessibility.
     */
    ariaLabel: string;
    /**
     *Specifies one or more IDs in the DOM that labels the input field.
     */
    ariaLabelledBy: string;
    /**
     *Defines a string that labels the dropdown button for accessibility.
     */
    dropdownAriaLabel: string;
    /**
     *Ensures uniqueness of selected items on multiple mode.
     */
    unique: boolean;
    /**
     *Used to define a string that autocomplete attribute the current element.
     */
    autocomplete: string;
    /**
     *When enabled, a clear icon is displayed to clear the value.
     */
    showClear: boolean;
    /**
     *Whether the data should be loaded on demand during scroll.
     */
    virtualScroll: boolean;
    /**
     *Height of an item in the list for VirtualScrolling.
     */
    virtualScrollItemSize: number;
    /**
     *Whether to use the scroller feature. The properties of scroller component can be used like an object in it.
     */
    virtualScrollOptions: ScrollerOptions;
    /**
     *Defines if data is loaded and interacted with in lazy manner.
     */
    lazy: boolean;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<AutoCompleteConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetAutoCompleteConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: AutoComplete);
    /**
     * input Auto Complete configs and assign configs to element
     */
    set setAutoCompleteConfigs(configs: AutoCompleteConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetAutoCompleteConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetAutoCompleteConfigsDirective, "[setAutoCompleteConfigs]", never, { "setAutoCompleteConfigs": "setAutoCompleteConfigs"; }, {}, never, never, false>;
}
