import { EventEmitter } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { ArrayUtilityService } from '../../../../../services/utility/array-utility.service';
import { FieldChangeOutput } from '../../../models/base-action';
import { AutoCompleteConfiguration } from './auto-complete.model';
import * as i0 from "@angular/core";
/**
 * Component Auto Complete
 */
export declare class PrgAutoCompleteComponent {
    private arrayUtilityService;
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     */
    constructor(arrayUtilityService: ArrayUtilityService);
    /**
     * Auto Complete Configs
     */
    configs: AutoCompleteConfiguration;
    /**
     * form
     */
    form: FormGroup;
    /**
     * output
     */
    onValueChange: EventEmitter<FieldChangeOutput>;
    /**
     * function that triggers the search for auto complete purpose
     */
    search(event: any): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgAutoCompleteComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgAutoCompleteComponent, "prg-auto-complete-field", never, { "configs": "configs"; "form": "form"; }, { "onValueChange": "onValueChange"; }, never, never, false>;
}
