import { EventEmitter } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { ActionOutput, BaseAction } from '../models/base-action';
import * as i0 from "@angular/core";
/**
 * Dynamic form action component
 */
export declare class PrgDynamicFormActionComponent {
    /**
     * actions types
     */
    actionTypes: {
        button: typeof import("./actions/button/button.component").PrgButtonComponent;
        splitButton: typeof import("./actions/split-button/split-button.component").PrgSplitButtonComponent;
        speedDial: typeof import("./actions/speed-dial/speed-dial.component").PrgSpeedDialComponent;
        selectButton: typeof import("./actions/select-button-action/select-button-action.component").PrgSelectButtonActionComponent;
        toggleButton: typeof import("./actions/toggle-button-action/toggle-button-action.component").PrgToggleButtonActionComponent;
        inputSwitch: typeof import("./actions/input-switch-action/input-switch-action.component").PrgInputSwitchActionComponent;
    };
    /**
     * receives a action
     */
    action: BaseAction;
    /**
     * receive the formGroup
     */
    form: FormGroup;
    /**
     * action Click output
     */
    actionClick: EventEmitter<ActionOutput>;
    /**
     * output to dynamic component
     */
    outputs: {
        actionClick: (action: ActionOutput) => void;
    };
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgDynamicFormActionComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgDynamicFormActionComponent, "prg-dynamic-form-action", never, { "action": "action"; "form": "form"; }, { "actionClick": "actionClick"; }, never, never, false>;
}
