import { ToggleButton } from 'primeng/togglebutton';
import { BaseAction } from '../../../models/base-action';
import * as i0 from "@angular/core";
/**
 * Class ToggleButton Action
 */
export declare class ToggleButtonActionConfiguration extends BaseAction {
    /**
     * control name
     */
    controlName?: string;
    /**
     *Enable inline label of the toggle button.
     */
    hasLabel: boolean;
    /**
     *Label for the on state.
     */
    onLabel: string;
    /**
     *Label for the off state.
     */
    offLabel: string;
    /**
     *Icon for the on state.
     */
    onIcon: string;
    /**
     *Icon for the off state.
     */
    offIcon: string;
    /**
     *Position of the icon, valid values are "left" and "right".
     */
    iconPos: string;
    /**
     *Inline style of the element.
     */
    style: string;
    /**
     *Style class of the element.
     */
    styleClass: string;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Identifier of the focus input to match a label defined for the component.
     */
    inputId: string;
    /**
     *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
     */
    ariaLabelledBy: string;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<ToggleButtonActionConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetToggleButtonActionConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: ToggleButton);
    /**
     * input ToggleButton configs and assign configs to element
     */
    set setToggleButtonActionConfigs(configs: ToggleButtonActionConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetToggleButtonActionConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetToggleButtonActionConfigsDirective, "[setToggleButtonActionConfigs]", never, { "setToggleButtonActionConfigs": "setToggleButtonActionConfigs"; }, {}, never, never, false>;
}
