import { SplitButton } from 'primeng/splitbutton';
import { PrgMenuItem } from '../../../../../../layouts/models/prg-menu-item';
import { BaseAction } from '../../../models/base-action';
import * as i0 from "@angular/core";
/**
 * Split Button Model
 */
export declare class SplitButtonConfiguration extends BaseAction {
    /**
     * Control name
     */
    controlName?: string;
    /**
     * items
     */
    items: PrgMenuItem[];
    /**
     *Target element to attach the overlay, valid values are body or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]=mydiv for a div element having #mydiv as variable name).
     */
    appendTo: any;
    /**
     *Indicates the direction of the element.
     */
    dir: string;
    /**
     *When present, it specifies that the component should be disabled.
     */
    disabled: boolean;
    /**
     *Defines a string that labels the expand button for accessibility.
     */
    expandAriaLabel: string;
    /**
     *Transition options of the hide animation.
     */
    hideTransitionOptions: string;
    /**
     *Name of the icon.
     */
    icon: string;
    /**
     *Position of the icon, valid values are left and right.
     */
    iconPos: string;
    /**
     *Text of the button.
     */
    label: string;
    /**
     *Inline style of the overlay menu.
     */
    menuStyle: string;
    /**
     *Style class of the overlay menu.
     */
    menuStyleClass: string;
    /**
     *Transition options of the show animation.
     */
    showTransitionOptions: string;
    /**
     *Inline style of the component.
     */
    style: string;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<SplitButtonConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSplitButtonConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: SplitButton);
    /**
     * set button configs, assign configs received to element
     */
    set setSplitButtonConfigs(configs: SplitButtonConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSplitButtonConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSplitButtonConfigsDirective, "[setSplitButtonConfigs]", never, { "setSplitButtonConfigs": "setSplitButtonConfigs"; }, {}, never, never, false>;
}
