import { EventEmitter } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { PrgMenuItem } from '../../../../../../layouts/models/prg-menu-item';
import { ArrayUtilityService } from '../../../../../services/utility/array-utility.service';
import { ActionOutput } from '../../../models/base-action';
import { SplitButtonConfiguration } from './split-button.model';
import * as i0 from "@angular/core";
/**
 * component split button
 */
export declare class PrgSplitButtonComponent {
    private arrayUtilityService;
    /**
     * Data of split button menu
     * @type {PrgMenuItem[]}
     */
    menuButton: PrgMenuItem[];
    /**
     * Split Button configs
     */
    set configs(configs: SplitButtonConfiguration);
    /**
     * Getter of configs
     * @returns {SplitButtonConfiguration}
     */
    get configs(): SplitButtonConfiguration;
    /**
     * Configs aux
     * @type {SplitButtonConfiguration}
     * @private
     */
    private _configs;
    /**
     * form
     */
    form: FormGroup;
    /**
     * output
     */
    actionClick: EventEmitter<ActionOutput>;
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     */
    constructor(arrayUtilityService: ArrayUtilityService);
    /**
     * function that triggers the output
     * @param {PrgMenuItem} menuItem
     */
    onButtonClicked(menuItem?: PrgMenuItem): void;
    /**
     * Assign commands to menu button
     * @param {PrgMenuItem[]} menuItems
     */
    assignCommandsToMenuButton(menuItems: PrgMenuItem[]): void;
    /**
     * Iterate over all children of menu button
     * @param {PrgMenuItem} itemChildren
     * @param {string} path
     * @returns {PrgMenuItem}
     */
    iterateOverChildren(itemChildren: PrgMenuItem, path: string): PrgMenuItem;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSplitButtonComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgSplitButtonComponent, "prg-button-action", never, { "configs": "configs"; "form": "form"; }, { "actionClick": "actionClick"; }, never, never, false>;
}
