import { SpeedDial } from 'primeng/speeddial';
import { PrgMenuItem } from '../../../../../../layouts/models/prg-menu-item';
import { BaseAction } from '../../../models/base-action';
import * as i0 from "@angular/core";
/**
 * class SpeedDialConfiguration
 */
export declare class SpeedDialConfiguration extends BaseAction {
    /**
     * Control name
     */
    controlName?: string;
    /**
     * items
     */
    items: PrgMenuItem[];
    /**
     *Style class of the button element.
     */
    buttonClassName: string;
    /**
     *Inline style of the button element.
     */
    buttonStyle: object;
    /**
     *Template of button element.
     */
    buttonTemplate: any;
    /**
     *Style class of the element.
     */
    className: string;
    /**
     *Specifies the opening direction of actions. Valid values are 'up', 'down', 'left', 'right', 'up-left', 'up-right', 'down-left' and 'down-right'
     */
    direction: string;
    /**
     *Whether the component is disabled.
     */
    disabled: boolean;
    /**
     *Hide icon of the button element.
     */
    hideIcon: string;
    /**
     *Whether the actions close when clicked outside.
     */
    hideOnClickOutside: boolean;
    /**
     *Unique identifier of the element.
     */
    id: string;
    /**
     *Whether to show a mask element behind the speeddial
     */
    mask: boolean;
    /**
     *Style class of the mask element.
     */
    maskClassName: string;
    /**
     *Inline style of the mask element.
     */
    maskStyle: object;
    /**
     *MenuModel instance to define the action items.
     */
    model: object;
    /**
     *Radius for *circle types.
     */
    radius: number;
    /**
     *Defined to rotate showIcon when hideIcon is not present.
     */
    rotateAnimation: boolean;
    /**
     *Show icon of the button element.
     */
    showIcon: string;
    /**
     *Inline style of the element.
     */
    style: object;
    /**
     *Transition delay step for each action item.
     */
    transitionDelay: number;
    /**
     *Specifies the visibility of the overlay.
     */
    visible: boolean;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<SpeedDialConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSpeedDialConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: SpeedDial);
    /**
     * set button configs, assign configs received to element
     */
    set setSpeedDialConfigs(configs: SpeedDialConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSpeedDialConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSpeedDialConfigsDirective, "[setSpeedDialConfigs]", never, { "setSpeedDialConfigs": "setSpeedDialConfigs"; }, {}, never, never, false>;
}
