import { EventEmitter } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { PrgMenuItem } from '../../../../../../layouts/models/prg-menu-item';
import { ArrayUtilityService } from '../../../../../services/utility/array-utility.service';
import { ActionOutput } from '../../../models/base-action';
import { SpeedDialConfiguration } from './speed-dial.model';
import * as i0 from "@angular/core";
/**
 * component speed dial
 */
export declare class PrgSpeedDialComponent {
    private arrayUtilityService;
    /**
     * Data of speed button menu
     * @type {PrgMenuItem[]}
     */
    menuButton: PrgMenuItem[];
    /**
     * Speed Dial configs
     */
    set configs(configs: SpeedDialConfiguration);
    /**
     * Getter of configs
     * @returns {SpeedDialConfiguration}
     */
    get configs(): SpeedDialConfiguration;
    /**
     * Configs aux
     * @type {SpeedDialConfiguration}
     * @private
     */
    private _configs;
    /**
     * form configs
     */
    form: FormGroup;
    /**
     * output
     */
    actionClick: EventEmitter<ActionOutput>;
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     */
    constructor(arrayUtilityService: ArrayUtilityService);
    /**
     * function that triggers the output
     * @param {PrgMenuItem} menuItem
     */
    onButtonClicked(menuItem: PrgMenuItem): void;
    /**
     * Assign commands to menu button
     * @param {PrgMenuItem[]} menuItems
     */
    assignCommandsToMenuButton(menuItems: PrgMenuItem[]): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSpeedDialComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgSpeedDialComponent, "prg-speed-dial-action", never, { "configs": "configs"; "form": "form"; }, { "actionClick": "actionClick"; }, never, never, false>;
}
