import { InputSwitch } from 'primeng/inputswitch';
import { BaseAction } from '../../../models/base-action';
import * as i0 from "@angular/core";
/**
 * Class Input Switch Action
 */
export declare class InputSwitchActionConfiguration extends BaseAction {
    /**
     * control name
     */
    controlName?: string;
    /**
     *Inline style of the component.
     */
    style: string;
    /**
     *Style class of the component.
     */
    styleClass: string;
    /**
     *Index of the element in tabbing order.
     */
    tabindex: number;
    /**
     *Identifier of the input element.
     */
    inputId: string;
    /**
     *Name of the input element.
     */
    name: string;
    /**
     *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
     */
    ariaLabelledBy: string;
    /**
     *Value in checked state.
     */
    trueValue: any;
    /**
     *Value in unchecked state.
     */
    falseValue: any;
    /**
     *Used to define a string that autocomplete attribute the current element.
     */
    ariaLabel: string;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<InputSwitchActionConfiguration>);
}
/**
 * Directive
 */
export declare class PrgSetInputSwitchActionConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: InputSwitch);
    /**
     * Input Switch Action configs and assign configs to element
     */
    set setInputSwitchActionConfigs(configs: InputSwitchActionConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSetInputSwitchActionConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgSetInputSwitchActionConfigsDirective, "[setInputSwitchActionConfigs]", never, { "setInputSwitchActionConfigs": "setInputSwitchActionConfigs"; }, {}, never, never, false>;
}
