import { Button } from 'primeng/button';
import { BaseAction } from '../../../models/base-action';
import * as i0 from "@angular/core";
/**
 * class ButtonConfiguration
 */
export declare class ButtonConfiguration extends BaseAction {
    /**
     * Control name
     */
    controlName?: string;
    /**
     *Used to define a string that autocomplete attribute the current element.
     */
    ariaLabel: string;
    /**
     *Value of the badge.
     */
    badge: string;
    /**
     *Style class of the badge.
     */
    badgeClass: string;
    /**
     *When present, it specifies that the component should be disabled.
     */
    disabled: boolean;
    /**
     *Name of the icon.
     */
    icon: string;
    /**
     *Position of the icon, valid values are left and right.
     */
    iconPos: string;
    /**
     *Text of the button.
     */
    label: string;
    /**
     *Whether the button is in loading state.
     */
    loading: boolean;
    /**
     *Icon to display in loading state.
     */
    loadingIcon: string;
    /**
     *Inline style of the element.
     */
    style: string;
    /**
     *Style class of the element.
     */
    styleClass: string;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<ButtonConfiguration>);
}
/**
 * Directive
 */
export declare class PrgButtonConfigsDirective {
    private element;
    /**
     * constructor
     * @param element
     */
    constructor(element: Button);
    /**
     * set button configs, assign configs received to element
     */
    set setButtonConfigs(configs: ButtonConfiguration);
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgButtonConfigsDirective, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<PrgButtonConfigsDirective, "[setButtonConfigs]", never, { "setButtonConfigs": "setButtonConfigs"; }, {}, never, never, false>;
}
