import { ConfigurationItem } from '../../models/configuration-item.model';
import { AbstractConfigurationItemsService } from './abstract-configuration-items.service';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class ConfigurationItemsService extends AbstractConfigurationItemsService {
    /**
     * Get a list of all configuration items
     * @returns {Promise<ConfigurationItem[]>}
     */
    getAllConfigurationItemsAsync(): Promise<ConfigurationItem[]>;
    /**
     * Function responsible to update Config Items
     * @param configItemData
     * @returns {Promise<ConfigurationItem[]>}
     */
    updateConfigurationItemsAsync(configItemData: any): Promise<ConfigurationItem[]>;
    /**
     * Get configuration items by path
     * @param {string} path
     * @returns {Promise<any>}
     */
    getConfigurationItemsByPathAsync(path: string): Promise<any>;
    static ɵfac: i0.ɵɵFactoryDeclaration<ConfigurationItemsService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ConfigurationItemsService>;
}
