import { BehaviorSubject, Observable } from 'rxjs';
import { ConfigurationItem } from '../../models/configuration-item.model';
/**
 * ConfigurationItemsService class that defines an
 * <br />abstract authentication service to
 * <br />be extended by the mock and real
 * <br />configuration items services
 */
export declare abstract class AbstractConfigurationItemsService {
    /**
     * Current configurationItems
     */
    protected configurationItemsSubject: BehaviorSubject<ConfigurationItem[]>;
    /**
     * Setter for configurationItemsSubject
     *
     * @param {ConfigurationItem[]} value The ConfigurationItems array
     */
    protected setConfigurationItems(value: ConfigurationItem[]): void;
    /**
     * Getter for configurationItemsSubject
     *
     * @returns The configurationItemsSubject as an observable
     */
    getConfigurationItemsObservable(): Observable<ConfigurationItem[]>;
    /**
     * Getter for configurationItemsSubject
     *
     * @returns The configurationItemsSubject current value
     */
    getConfigurationItemsValue(): ConfigurationItem[];
    /**
     * Get a list of all configuration items
     * @returns {Promise<ConfigurationItem[]>}
     */
    abstract getAllConfigurationItemsAsync(): Promise<ConfigurationItem[]>;
    /**
     * Function responsible to update Config Items
     * @param configItemData
     * @returns {Promise<ConfigurationItem[]>}
     */
    abstract updateConfigurationItemsAsync(configItemData: any): Promise<ConfigurationItem[]>;
    /**
     * Get configuration items by path
     * @param {string} path
     * @returns {Promise<any>}
     */
    abstract getConfigurationItemsByPathAsync(path: string): Promise<any>;
}
