/**
 * ConfigurationItem class that defines generic configurations
 */
import { BaseEntity } from '../../core/models/base-entity.model';
/**
 * The model of Configuration Items
 */
export declare class ConfigurationItem extends BaseEntity {
    /**
     * Path that leads to the item (excluding itself)
     * <br />e.g. "Identity:SignIn"
     * <br />the node name is on the name property from BaseEntity
     */
    path: string;
    /**
     * Item value
     */
    value: any;
    /**
     * Item value type
     */
    /**
     * gui settings
     * @type {string}
     */
    guiSettings: string;
    /**
     * Item is system
     */
    readonly: boolean;
    /**
     * Constructor
     * @param {Partial<ConfigurationItem>} init
     */
    constructor(init?: Partial<ConfigurationItem>);
}
/**
 * Enum of most common sub-paths of config items
 */
export declare enum ConfigItemsPath {
    Defaults = "Defaults",
    UserPreferences = "User-Preferences"
}
