import { AbstractAuthService } from '../../../auth/services/auth/abstract-auth.service';
import { IsLoadingDataService } from '../../../core/services/is-loading-data/isloadingdata.service';
import { NotificationsService } from '../../../core/services/notifications/notifications.service';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../core/services/utility/utility.service';
import { ConfigurationItem } from '../../models/configuration-item.model';
import { AbstractConfigurationItemsService } from '../../services/configuration-items/abstract-configuration-items.service';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class MockConfigurationItemsService extends AbstractConfigurationItemsService {
    private notificationsService;
    private utilityService;
    private isLoadingData;
    private objectsUtilityService;
    private arrayUtilityService;
    private authService;
    /**
     * default time in seconds
     */
    private sleepTimeSec;
    /**
     * Constructor
     * @param {NotificationsService} notificationsService
     * @param {UtilityService} utilityService
     * @param {IsLoadingDataService} isLoadingData
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {AbstractAuthService} authService
     */
    constructor(notificationsService: NotificationsService, utilityService: UtilityService, isLoadingData: IsLoadingDataService, objectsUtilityService: ObjectsUtilityService, arrayUtilityService: ArrayUtilityService, authService: AbstractAuthService);
    /**
     * Get a list of all configuration items
     * @returns {Promise<ConfigurationItem[]>}
     */
    getAllConfigurationItemsAsync(): Promise<ConfigurationItem[]>;
    /**
     * Update a configuration items
     * @param configItemData
     * @returns {Promise<ConfigurationItem[]>}
     */
    updateConfigurationItemsAsync(configItemData: any): Promise<ConfigurationItem[]>;
    /**
     * Get configuration items by path
     * @param {string} path
     * @returns {Promise<any>}
     */
    getConfigurationItemsByPathAsync(path: string): Promise<any>;
    static ɵfac: i0.ɵɵFactoryDeclaration<MockConfigurationItemsService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<MockConfigurationItemsService>;
}
