import { OnInit } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { User } from '../../../auth/models/user.model';
import { AbstractAuthService } from '../../../auth/services/auth/abstract-auth.service';
import { BaseAction, DynamicFormActionOutput } from '../../../core/components/dynamic-form/models/base-action';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../core/services/utility/utility.service';
import { AbstractConfigurationItemsService } from '../../services/configuration-items/abstract-configuration-items.service';
import * as i0 from "@angular/core";
/**
 * Config items user component
 */
export declare class PrgConfigItemsUserComponent implements OnInit {
    private configurationItemsService;
    private arrayUtilityService;
    private utilityService;
    private translateService;
    private objectUtility;
    private authService;
    /**
     * The view mode type of the form. Default is "read"
     * @type {ViewMode}
     */
    configItemsViewMode: ViewMode;
    /**
     * The complete path for the config item user-preferences defaults
     * @type {string}
     */
    configItemUserPreferencesDefaultsPath: string;
    /**
     * A boolean property of the class to show/hide form. Default is false(hide)
     * @type {boolean}
     */
    initForm: boolean;
    /**
     * An object with the data to build form , keys and values
     * @type {any}
     */
    entityConfigItems: any;
    /**
     * The title of the form of configuration item
     * @type {string}
     */
    titleForm: string;
    /**
     * The dynamic form fields to build dynamic form config items in template
     */
    configItemsDynamicFormFields: any[];
    /**
     * The dynamic form actions to build dynamic form config items in template
     */
    configItemsDynamicFormActions: BaseAction[];
    /**
     * A copy of entityConfigItems object
     * @type {any}
     * @private
     */
    private entityConfigItemCopy;
    /**
     * User and defaults config items
     * @type {any}
     */
    userAndDefaultsConfigsItems: any;
    /**
     * Current logged User
     * @type {User}
     */
    loggedUser: User;
    /**
     * The path of user preferences for the current logged user
     * @type {string}
     */
    configItemUserPath: string;
    /**
     * The configuration items defaults of user preferences
     * @type {ConfigurationItem[]}
     * @private
     */
    private configItemsUserPreferencesDefaults;
    /**
     * The configuration items of user preferences of current user
     * @type {ConfigurationItem[]}
     * @private
     */
    private configItemsUserPreferences;
    /**
     * Constructor
     * @param {AbstractConfigurationItemsService} configurationItemsService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {UtilityService} utilityService
     * @param {TranslateService} translateService
     * @param {ObjectsUtilityService} objectUtility
     * @param {AbstractAuthService} authService
     */
    constructor(configurationItemsService: AbstractConfigurationItemsService, arrayUtilityService: ArrayUtilityService, utilityService: UtilityService, translateService: TranslateService, objectUtility: ObjectsUtilityService, authService: AbstractAuthService);
    /**
     * ngOnInit
     *
     * Get  configuration items User Preferences and settings to initiate the template
     * @returns {Promise<void>}
     */
    ngOnInit(): Promise<void>;
    /**
     * This function is responsible to get Config Items regarding user logged
     * @returns {Promise<void>}
     */
    getConfigItemsUserPreferencesByLoggedUser(): Promise<void>;
    /**
     * This function is responsible to get the gui settings of config item and parse it
     * @returns {any}
     * @private
     */
    private getAndParseGuiSettingsItems;
    /**
     * This function will assign config items data to form
     * @private
     */
    private assignConfigItemDataToForm;
    /**
     * This function will set the title of the form
     * @private
     */
    private setTitleForm;
    /**
     * This function is responsible to handle actions from the dynamic config items form
     * @param {DynamicFormActionOutput} event
     * @returns {Promise<void>}
     */
    onActionConfigItems(event: DynamicFormActionOutput): Promise<void>;
    /**
     * This function is responsible to save a new config item or update an existing one
     * @param {DynamicFormActionOutput} event
     * @returns {Promise<void>}
     * @private
     */
    private configItemsSave;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgConfigItemsUserComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgConfigItemsUserComponent, "prg-config-items-user", never, { "configItemUserPreferencesDefaultsPath": "configItemUserPreferencesDefaultsPath"; }, {}, never, never, false>;
}
