import { OnInit } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { TreeNode } from 'primeng/api';
import { BaseAction, DynamicFormActionOutput } from '../../../core/components/dynamic-form/models/base-action';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../core/services/utility/utility.service';
import { AbstractConfigurationItemsService } from '../../services/configuration-items/abstract-configuration-items.service';
import * as i0 from "@angular/core";
/**
 * Config items admin component
 */
export declare class PrgConfigItemsAdminComponent implements OnInit {
    private configurationItemsService;
    private arrayUtilityService;
    private utilityService;
    private translateService;
    private objectUtility;
    /**
     * The structure of the tree including paths and data
     * @type {TreeNode[]}
     */
    configItemsTree: TreeNode[];
    /**
     * The current selected node of the tree
     * @type {TreeNode}
     */
    selectedNode: TreeNode;
    /**
     * The view mode type of the form. Default is "read"
     * @type {ViewMode}
     */
    configItemsViewMode: ViewMode;
    /**
     * A boolean property of the class to show/hide form. Default is false(hide)
     * @type {boolean}
     */
    initForm: boolean;
    /**
     * An object with the data to build form , keys and values
     * @type {any}
     */
    entityConfigItems: any;
    /**
     * The title of the form of configuration item
     * @type {string}
     */
    titleForm: string;
    /**
     * The dynamic form fields to build dynamic form config items in template
     */
    configItemsDynamicFormFields: any[];
    /**
     * The dynamic form actions to build dynamic form config items in template
     */
    configItemsDynamicFormActions: BaseAction[];
    /**
     * A copy of entityConfigItems object
     * @type {any}
     * @private
     */
    private entityConfigItemCopy;
    /**
     * The list of configuration items
     * @type {ConfigurationItem[]}
     */
    private configItemsList;
    /**
     * The configuration items defaults selected on tree
     * @type {ConfigurationItem[]}
     */
    private configItemsSelectedDefaults;
    /**
     * The configuration items selected on tree
     * @type {ConfigurationItem[]}
     */
    private configItemsSelected;
    /**
     * Constructor
     * @param {AbstractConfigurationItemsService} configurationItemsService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {UtilityService} utilityService
     * @param {TranslateService} translateService
     * @param {ObjectsUtilityService} objectUtility
     */
    constructor(configurationItemsService: AbstractConfigurationItemsService, arrayUtilityService: ArrayUtilityService, utilityService: UtilityService, translateService: TranslateService, objectUtility: ObjectsUtilityService);
    /**
     * ngOnInit
     *
     * Get all configuration item
     * @returns {Promise<void>}
     */
    ngOnInit(): Promise<void>;
    /**
     * This function call rearrange all config item paths and build tree menu
     * @private
     */
    private setTreeData;
    /**
     * This function is responsible toe execute actions whenever a node is selected on tree
     * @param {TreeNode} node
     */
    onSelectItem(node: TreeNode): void;
    /**
     * This function is responsible to get the complete path of item selected and their default path if
     * they exist. Then it will get the data of config items selected
     * @param {TreeNode} node
     * @private
     */
    private setConfigItemsSelected;
    /**
     * This function is responsible to get the complete path of the item in tree
     * @param {TreeNode} node
     * @returns {string}
     * @private
     */
    private static getCompletePathOfItem;
    /**
     * This function it will set the title of the form
     * @private
     */
    private setTitleForm;
    /**
     * This function will assign config items data to form
     * @private
     */
    private assignConfigItemDataToForm;
    /**
     * This function is responsible to get the gui settings of the item selected and parse it
     * @returns {any}
     * @private
     */
    private getAndParseGuiSettingsItems;
    /**
     * This function is responsible to handle actions from the dynamic config items form
     * @param {DynamicFormActionOutput} event
     * @returns {Promise<void>}
     */
    onActionConfigItems(event: DynamicFormActionOutput): Promise<void>;
    /**
     * This function is responsible to save a new config item or update an existing one
     * @param {DynamicFormActionOutput} event
     * @returns {Promise<void>}
     * @private
     */
    private configItemsSave;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgConfigItemsAdminComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgConfigItemsAdminComponent, "prg-config-items-admin", never, {}, {}, never, never, false>;
}
