import { ValidationErrors, ValidatorFn } from '@angular/forms';
/**
 * This class define methods to validate passwords
 */
export declare class PrgAuthCustomPasswordRequirements {
    /**
     * Method to validate passwords through Regular Expression (RegExp)
     * @param {RegExp} regex
     * @param {ValidationErrors} error
     * @param {boolean} passwordRequirements
     * @returns {ValidatorFn}
     */
    static patternValidator(regex: RegExp, error: ValidationErrors, passwordRequirements: boolean): ValidatorFn;
    /**
     * Method to validate passwords with a number of unique chars
     * @param {number} numberUniqueChars
     * @param {ValidationErrors} error
     * @returns {ValidatorFn}
     */
    static uniqueCharsValidator(numberUniqueChars: number, error: ValidationErrors): ValidatorFn;
    /**
     * Method to validate if password and confirm password match
     * @param {AbstractControl} group
     * @returns {ValidationErrors | null}
     */
    static passwordMatchValidator: ValidatorFn;
}
