import { HttpClient } from '@angular/common/http';
import { AuthStorage } from '../../models/prg-auth-config';
import { AbstractAuthService } from './abstract-auth.service';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class AuthService extends AbstractAuthService {
    private http;
    private readonly baseUrl;
    /**
     * constructor
     * @param {AuthStorage} authStorage
     * @param {HttpClient} http
     */
    constructor(authStorage: AuthStorage, http: HttpClient);
    /**
     * User login (Async)
     *
     * @param {string} email The user e-mail
     * @param {string} password The user password
     * @param {boolean} storeUserName Store username
     * @returns Boolean promise, true when successful
     */
    loginAsync(email: string, password: string, storeUserName: boolean): Promise<boolean>;
    /**
     * User logout (Async)
     *
     * @returns Boolean promise, true when successful
     */
    logoutAsync(): Promise<boolean>;
    /**
     * User sign up (Async)
     *
     * @param {string} email The user e-mail
     * @returns Boolean promise, true when successful
     */
    signupAsync(email: string): Promise<boolean>;
    /**
     * Request to reset the password (Async)
     *
     * @param {string} email The user e-mail
     * @returns Boolean promise, true when successful
     */
    requestResetPasswordAsync(email: string): Promise<boolean>;
    /**
     * Getter for token reset password (Async)
     *
     * @param {string} tokenReset The token reset password
     * @returns Boolean promise, true when successful
     */
    getTokenResetPasswordAsync(tokenReset: string): Promise<boolean>;
    /**
     * Method for reset password (Async)
     *
     * @param {string} newPassword The new password
     * @param {string} tokenReset The token reset password
     * @returns Boolean promise, true when successful
     */
    resetPasswordAsync(newPassword: string, tokenReset: string): Promise<boolean>;
    static ɵfac: i0.ɵɵFactoryDeclaration<AuthService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<AuthService>;
}
