/**
 * Token class that defines some basic JWT
 * <br />properties and adds additional
 * <br />generic properties required by the
 * <br />front-end
 */
export declare class Token {
    /**
     * User roles array (may only be included
     * <br />if a configuration item is true)
     */
    roles: string[];
    /**
     * User scopes array
     */
    scopes: string[];
    /**
     * * Workspace id
     */
    workspaceId: string;
    /**
     * User id
     */
    userId: string;
    /**
     * Type of token (normally "Bearer")
     */
    typ: string;
    /**
     * User unique name
     */
    unique_name: string;
    /**
     * User profile image url
     */
    imageUrl: string;
    /**
     * Constructor
     */
    constructor(init?: Partial<Token>);
}
/**
 * PasswordRequirements configuration items model
 * <br />to be used when creating or resetting
 * <br />user passwords
 */
export declare class PasswordRequirements {
    /**
     * Gets or sets the minimum length a password must be. Defaults to 6.
     */
    requiredLength: number;
    /**
     * Gets or sets the minimum number of unique characters which a password must contain.
     *<br />Defaults to 1.
     */
    requiredUniqueChars: number;
    /**
     * Gets or sets a flag indicating if passwords must contain a non-alphanumeric character.
     * <br />Defaults to true.
     */
    requireNonAlphanumeric: boolean;
    /**
     * Gets or sets a flag indicating if passwords must contain a lower case ASCII character.
     * <br />Defaults to true.
     */
    requireLowercase: boolean;
    /**
     * Gets or sets a flag indicating if passwords must contain a upper case ASCII character.
     * <br />Defaults to true.
     */
    requireUppercase: boolean;
    /**
     * Gets or sets a flag indicating if passwords must contain a digit.
     * <br />Defaults to true.
     */
    requireDigit: boolean;
}
/**
 * User class that defines the basic properties
 * <br />of an user.
 */
export declare class User {
    /**
     * Id
     */
    id: string;
    /**
     * Name
     */
    name: string;
    /**
     * Token
     */
    token: Token;
    /**
     * Email
     */
    email: string;
    /**
     * Password
     */
    password: string;
    /**
     * Reset Password token
     */
    tokenResetPassword: string;
    /**
     * Constructor
     * @param {Partial<User>} init
     */
    constructor(init?: Partial<User>);
}
