/**
 * Interface that defines the data that can be
 * <br />passed by the consuming app to the module
 */
export interface PrgAuthConfig {
    /**
     * If useMockServicess is true, the Mock Services will be used,
     * <br />else the real API Services will be used
     */
    useMockServices: boolean;
    /**
     * The base path of authentication to be used on the PrgAuthRoutingModule
     */
    authRoutingBasePath: string;
    /**
     * The path of signup page
     */
    authRoutingSignupPath: string;
    /**
     * The path of login page
     */
    authRoutingLoginPath: string;
    /**
     * The path of request password page
     */
    authRoutingRequestPasswordPath: string;
    /**
     * The path of reset password page
     */
    authRoutingResetPasswordPath: string;
    /**
     * The path of to redirect if login success
     */
    authRoutingLoginOkRedirectPath: string;
    /**
     * The path of terms of use page
     */
    termsOfUseRoutingPath: string;
    /**
     * The auth storage of AuthStorage for locally store data of user
     */
    authStorage: AuthStorage;
}
/**
 * this interface has the elements to define a window local storage and its keys to use on PrgAuthConfig
 */
export interface AuthStorage {
    /**
     * Property of type storage
     */
    storage: Storage;
    /**
     * Key to store the username on local storage
     */
    keyStoredUserName: string;
    /**
     * Key to store the user data
     */
    keyLoggedUser: string;
}
